/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.util.Helper;

public enum RouteNetwork {
    MISSING,
    INTERNATIONAL,
    NATIONAL,
    REGIONAL,
    LOCAL,
    OTHER;


    public static String key(String prefix) {
        return prefix + "_network";
    }

    public static EnumEncodedValue<RouteNetwork> create(String name) {
        return new EnumEncodedValue<RouteNetwork>(name, RouteNetwork.class);
    }

    public String toString() {
        return Helper.toLowerCase(super.toString());
    }

    public static RouteNetwork find(String name) {
        if (Helper.isEmpty(name)) {
            return MISSING;
        }
        try {
            return RouteNetwork.valueOf(Helper.toUpperCase(name));
        }
        catch (IllegalArgumentException ex) {
            return MISSING;
        }
    }
}

