/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayDeque;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TarjanSCC {
    private final Graph graph;
    private final EdgeExplorer explorer;
    private final EdgeFilter edgeFilter;
    private final BitUtil bitUtil = BitUtil.LITTLE;
    private final int[] nodeIndex;
    private final int[] nodeLowLink;
    private final BitSet nodeOnStack;
    private final IntArrayDeque tarjanStack;
    private final LongArrayDeque dfsStack;
    private final ConnectedComponents components;
    private final boolean excludeSingleNodeComponents;
    private int currIndex = 0;
    private int v;
    private int w;
    private State dfsState;

    public static ConnectedComponents findComponents(Graph graph, EdgeFilter edgeFilter, boolean excludeSingleNodeComponents) {
        return new TarjanSCC(graph, edgeFilter, excludeSingleNodeComponents).findComponents();
    }

    public static ConnectedComponents findComponentsRecursive(Graph graph, EdgeFilter edgeFilter, boolean excludeSingleNodeComponents) {
        return new TarjanSCC(graph, edgeFilter, excludeSingleNodeComponents).findComponentsRecursive();
    }

    private TarjanSCC(Graph graph, EdgeFilter edgeFilter, boolean excludeSingleNodeComponents) {
        this.graph = graph;
        this.edgeFilter = edgeFilter;
        this.explorer = graph.createEdgeExplorer(edgeFilter);
        this.nodeIndex = new int[graph.getNodes()];
        this.nodeLowLink = new int[graph.getNodes()];
        Arrays.fill(this.nodeIndex, -1);
        Arrays.fill(this.nodeLowLink, -1);
        this.nodeOnStack = new BitSet(graph.getNodes());
        if (!this.nodeOnStack.getClass().getName().contains("hppc")) {
            throw new IllegalStateException("Was meant to be hppc BitSet");
        }
        this.tarjanStack = new IntArrayDeque();
        this.dfsStack = new LongArrayDeque();
        this.components = new ConnectedComponents(excludeSingleNodeComponents ? -1 : graph.getNodes());
        this.excludeSingleNodeComponents = excludeSingleNodeComponents;
    }

    private ConnectedComponents findComponentsRecursive() {
        for (int node = 0; node < this.graph.getNodes(); ++node) {
            if (this.nodeIndex[node] != -1) continue;
            this.findComponentForNode(node);
        }
        return this.components;
    }

    private void findComponentForNode(int v) {
        this.setupNextNode(v);
        EdgeExplorer explorer = this.graph.createEdgeExplorer(this.edgeFilter);
        EdgeIterator iter = explorer.setBaseNode(v);
        while (iter.next()) {
            int w = iter.getAdjNode();
            if (this.nodeIndex[w] == -1) {
                this.findComponentForNode(w);
                this.nodeLowLink[v] = Math.min(this.nodeLowLink[v], this.nodeLowLink[w]);
                continue;
            }
            if (!this.nodeOnStack.get(w)) continue;
            this.nodeLowLink[v] = Math.min(this.nodeLowLink[v], this.nodeIndex[w]);
        }
        this.buildComponent(v);
    }

    private void setupNextNode(int v) {
        this.nodeIndex[v] = this.currIndex;
        this.nodeLowLink[v] = this.currIndex++;
        this.tarjanStack.addLast(v);
        this.nodeOnStack.set(v);
    }

    private void buildComponent(int v) {
        if (this.nodeLowLink[v] == this.nodeIndex[v]) {
            if (this.tarjanStack.getLast() == v) {
                this.tarjanStack.removeLast();
                this.nodeOnStack.clear(v);
                ++this.components.numComponents;
                ++this.components.numNodes;
                if (!this.excludeSingleNodeComponents) {
                    this.components.singleNodeComponents.set(v);
                }
            } else {
                int w;
                IntArrayList component = new IntArrayList();
                do {
                    w = this.tarjanStack.removeLast();
                    component.add(w);
                    this.nodeOnStack.clear(w);
                } while (w != v);
                component.trimToSize();
                assert (component.size() > 1);
                ++this.components.numComponents;
                this.components.numNodes += component.size();
                this.components.components.add(component);
                if (component.size() > this.components.biggestComponent.size()) {
                    this.components.biggestComponent = component;
                }
            }
        }
    }

    private ConnectedComponents findComponents() {
        for (int node = 0; node < this.graph.getNodes(); ++node) {
            if (this.nodeIndex[node] != -1) continue;
            this.pushFindComponentForNode(node);
            block7: while (this.hasNext()) {
                this.pop();
                switch (this.dfsState.ordinal()) {
                    case 3: {
                        this.buildComponent(this.v);
                        continue block7;
                    }
                    case 0: {
                        this.nodeLowLink[this.v] = Math.min(this.nodeLowLink[this.v], this.nodeLowLink[this.w]);
                        continue block7;
                    }
                    case 1: {
                        if (this.nodeIndex[this.w] != -1 && this.nodeOnStack.get(this.w)) {
                            this.nodeLowLink[this.v] = Math.min(this.nodeLowLink[this.v], this.nodeIndex[this.w]);
                        }
                        if (this.nodeIndex[this.w] != -1) continue block7;
                        this.pushUpdateLowLinks(this.v, this.w);
                        this.pushFindComponentForNode(this.w);
                        continue block7;
                    }
                    case 2: {
                        this.setupNextNode(this.v);
                        this.pushBuildComponent(this.v);
                        EdgeIterator iter = this.explorer.setBaseNode(this.v);
                        while (iter.next()) {
                            this.pushHandleNeighbor(this.v, iter.getAdjNode());
                        }
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unknown state: " + String.valueOf((Object)this.dfsState));
            }
        }
        return this.components;
    }

    private boolean hasNext() {
        return !this.dfsStack.isEmpty();
    }

    private void pop() {
        long l = this.dfsStack.removeLast();
        int low = this.bitUtil.getIntLow(l);
        int high = this.bitUtil.getIntHigh(l);
        if (low > 0 && high > 0) {
            this.dfsState = State.HANDLE_NEIGHBOR;
            this.v = low - 1;
            this.w = high - 1;
        } else if (low > 0 && high < 0) {
            this.dfsState = State.UPDATE;
            this.v = low - 1;
            this.w = -high - 1;
        } else if (low == 0) {
            this.dfsState = State.BUILD_COMPONENT;
            this.v = high - 1;
            this.w = -1;
        } else {
            this.dfsState = State.FIND_COMPONENT;
            this.v = low - 1;
            this.w = -1;
        }
    }

    private void pushHandleNeighbor(int v, int w) {
        assert (v >= 0 && v < Integer.MAX_VALUE);
        assert (w >= 0 && w < Integer.MAX_VALUE);
        this.dfsStack.addLast(this.bitUtil.toLong(v + 1, w + 1));
    }

    private void pushUpdateLowLinks(int v, int w) {
        assert (v >= 0 && v < Integer.MAX_VALUE);
        assert (w >= 0 && w < Integer.MAX_VALUE);
        this.dfsStack.addLast(this.bitUtil.toLong(v + 1, -(w + 1)));
    }

    private void pushBuildComponent(int v) {
        assert (v >= 0 && v < Integer.MAX_VALUE);
        this.dfsStack.addLast(this.bitUtil.toLong(0, v + 1));
    }

    private void pushFindComponentForNode(int v) {
        assert (v >= 0 && v < Integer.MAX_VALUE);
        this.dfsStack.addLast(this.bitUtil.toLong(v + 1, 0));
    }

    public static class ConnectedComponents {
        private final List<IntArrayList> components = new ArrayList<IntArrayList>();
        private final BitSet singleNodeComponents;
        private IntArrayList biggestComponent;
        private int numComponents;
        private int numNodes;

        ConnectedComponents(int nodes) {
            this.singleNodeComponents = new BitSet(Math.max(nodes, 0));
            if (!this.singleNodeComponents.getClass().getName().contains("hppc")) {
                throw new IllegalStateException("Was meant to be hppc BitSet");
            }
            this.biggestComponent = new IntArrayList();
        }

        public List<IntArrayList> getComponents() {
            return this.components;
        }

        public BitSet getSingleNodeComponents() {
            return this.singleNodeComponents;
        }

        public int getTotalComponents() {
            return this.numComponents;
        }

        public IntArrayList getBiggestComponent() {
            return this.biggestComponent;
        }

        public int getNodes() {
            return this.numNodes;
        }
    }

    private static enum State {
        UPDATE,
        HANDLE_NEIGHBOR,
        FIND_COMPONENT,
        BUILD_COMPONENT;

    }
}

