/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.countryrules;

import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.countryrules.europe.AustriaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.GermanyCountryRule;
import com.graphhopper.routing.util.countryrules.europe.HungaryCountryRule;
import java.util.EnumMap;
import java.util.Map;

public class CountryRuleFactory {
    private final Map<Country, CountryRule> rules = new EnumMap<Country, CountryRule>(Country.class);

    public CountryRuleFactory() {
        this.rules.put(Country.AUT, new AustriaCountryRule());
        this.rules.put(Country.DEU, new GermanyCountryRule());
        this.rules.put(Country.HUN, new HungaryCountryRule());
    }

    public CountryRule getCountryRule(Country country) {
        return this.rules.get((Object)country);
    }

    public Map<Country, CountryRule> getCountryToRuleMap() {
        return this.rules;
    }
}

