/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAccessParser
implements TagParser {
    static final Collection<String> ONEWAYS = Arrays.asList("yes", "true", "1", "-1");
    static final Collection<String> INTENDED = Arrays.asList("yes", "designated", "official", "permissive");
    protected final List<String> restrictionKeys;
    protected final Set<String> restrictedValues = new HashSet<String>(5);
    protected final Set<String> allowedValues = new HashSet<String>(INTENDED);
    protected final Set<String> barriers = new HashSet<String>(5);
    protected final BooleanEncodedValue accessEnc;
    private boolean blockFords = true;

    protected AbstractAccessParser(BooleanEncodedValue accessEnc, List<String> restrictionKeys) {
        this.accessEnc = accessEnc;
        this.restrictionKeys = restrictionKeys;
        this.allowedValues.add("destination");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.restrictedValues.add("private");
        this.restrictedValues.add("permit");
    }

    public boolean isBlockFords() {
        return this.blockFords;
    }

    protected void blockFords(boolean blockFords) {
        this.blockFords = blockFords;
    }

    protected void blockPrivate(boolean blockPrivate) {
        if (!blockPrivate) {
            if (!this.restrictedValues.remove("private")) {
                throw new IllegalStateException("no 'private' found in restrictedValues");
            }
            if (!this.restrictedValues.remove("permit")) {
                throw new IllegalStateException("no 'permit' found in restrictedValues");
            }
            this.allowedValues.add("private");
            this.allowedValues.add("permit");
        }
    }

    protected void handleBarrierEdge(int edgeId, EdgeIntAccess edgeIntAccess, Map<String, Object> nodeTags) {
        ReaderNode readerNode = new ReaderNode(0L, 0.0, 0.0, nodeTags);
        if (this.isBarrier(readerNode)) {
            BooleanEncodedValue accessEnc = this.getAccessEnc();
            accessEnc.setBool(false, edgeId, edgeIntAccess, false);
            accessEnc.setBool(true, edgeId, edgeIntAccess, false);
        }
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        this.handleWayTags(edgeId, edgeIntAccess, way);
    }

    public abstract void handleWayTags(int var1, EdgeIntAccess var2, ReaderWay var3);

    public boolean isBarrier(ReaderNode node) {
        String firstValue = node.getFirstValue(this.restrictionKeys);
        if (this.restrictedValues.contains(firstValue)) {
            return true;
        }
        if (node.hasTag("locked", (Object)"yes") && !this.allowedValues.contains(firstValue)) {
            return true;
        }
        if (this.allowedValues.contains(firstValue)) {
            return false;
        }
        if (node.hasTag("barrier", this.barriers)) {
            return true;
        }
        return this.blockFords && node.hasTag("ford", (Object)"yes");
    }

    public final BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }

    public final List<String> getRestrictionKeys() {
        return this.restrictionKeys;
    }

    public final String getName() {
        return this.accessEnc.getName();
    }

    public String toString() {
        return this.getName();
    }
}

