/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMTemporalAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FootAccessParser
extends AbstractAccessParser
implements TagParser {
    final Set<String> allowedHighwayTags = new HashSet<String>();
    protected HashSet<String> sidewalkValues = new HashSet(5);
    protected Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();

    public FootAccessParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key("foot")));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    protected FootAccessParser(BooleanEncodedValue accessEnc) {
        super(accessEnc, OSMRoadAccessParser.toOSMRestrictions(TransportationMode.FOOT));
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.barriers.add("fence");
        this.allowedHighwayTags.add("footway");
        this.allowedHighwayTags.add("path");
        this.allowedHighwayTags.add("steps");
        this.allowedHighwayTags.add("pedestrian");
        this.allowedHighwayTags.add("living_street");
        this.allowedHighwayTags.add("track");
        this.allowedHighwayTags.add("residential");
        this.allowedHighwayTags.add("service");
        this.allowedHighwayTags.add("platform");
        this.allowedHighwayTags.add("trunk");
        this.allowedHighwayTags.add("trunk_link");
        this.allowedHighwayTags.add("primary");
        this.allowedHighwayTags.add("primary_link");
        this.allowedHighwayTags.add("secondary");
        this.allowedHighwayTags.add("secondary_link");
        this.allowedHighwayTags.add("tertiary");
        this.allowedHighwayTags.add("tertiary_link");
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
        this.allowedHighwayTags.add("bridleway");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
    }

    public WayAccess getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String footTag;
            WayAccess acceptPotentially = WayAccess.CAN_SKIP;
            if (FerrySpeedCalculator.isFerry(way) && ((footTag = way.getTag("foot")) == null || this.allowedValues.contains(footTag))) {
                acceptPotentially = WayAccess.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                acceptPotentially = WayAccess.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                acceptPotentially = WayAccess.WAY;
            }
            if (!acceptPotentially.canSkip()) {
                if (way.hasTag((List<String>)this.restrictionKeys, (Collection<String>)this.restrictedValues)) {
                    return WayAccess.CAN_SKIP;
                }
                return acceptPotentially;
            }
            return WayAccess.CAN_SKIP;
        }
        if ("via_ferrata".equals(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        int firstIndex = way.getFirstIndex(this.restrictionKeys);
        if (firstIndex >= 0) {
            String[] restrict;
            String firstValue = way.getTag((String)this.restrictionKeys.get(firstIndex), "");
            for (String value : restrict = firstValue.split(";")) {
                if (!this.allowedValues.contains(value)) continue;
                return WayAccess.WAY;
            }
            for (String value : restrict) {
                if (!this.restrictedValues.contains(value) || OSMTemporalAccessParser.hasPermissiveTemporalRestriction(way, firstIndex, this.restrictionKeys, this.allowedValues)) continue;
                return WayAccess.CAN_SKIP;
            }
        }
        if (way.hasTag("sidewalk", this.sidewalkValues)) {
            return WayAccess.WAY;
        }
        if (!this.allowedHighwayTags.contains(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return WayAccess.CAN_SKIP;
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        if (way.hasTag("oneway:foot", (Collection<String>)ONEWAYS) || way.hasTag("foot:backward", new String[0]) || way.hasTag("foot:forward", new String[0]) || way.hasTag("oneway", (Collection<String>)ONEWAYS) && way.hasTag("highway", (Object)"steps")) {
            boolean reverse = way.hasTag("oneway:foot", (Object)"-1") || way.hasTag("foot:backward", (Object)"yes") || way.hasTag("foot:forward", (Object)"no");
            this.accessEnc.setBool(reverse, edgeId, edgeIntAccess, true);
        } else {
            this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
            this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
        }
        if (way.hasTag("gh:barrier_edge", new String[0])) {
            List nodeTags = way.getTag("node_tags", Collections.emptyList());
            this.handleBarrierEdge(edgeId, edgeIntAccess, (Map)nodeTags.get(0));
        }
    }
}

