/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.MaxWeightExcept;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import java.util.List;
import java.util.stream.Collectors;

public class MaxWeightExceptParser
implements TagParser {
    private final EnumEncodedValue<MaxWeightExcept> mweEnc;
    private static final List<String> HGV_RESTRICTIONS = OSMRoadAccessParser.toOSMRestrictions(TransportationMode.HGV).stream().map(e -> e + ":conditional").collect(Collectors.toList());

    public MaxWeightExceptParser(EnumEncodedValue<MaxWeightExcept> mweEnc) {
        this.mweEnc = mweEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        String value;
        String[] values2;
        String condValue = way.getTag("maxweight:conditional", "");
        if (!condValue.isEmpty() && (values2 = condValue.split("@")).length == 2) {
            String key = values2[0].trim();
            value = values2[1].trim();
            if ("no".equals(key) || "none".equals(key)) {
                if (value.startsWith("(") && value.endsWith(")")) {
                    value = value.substring(1, value.length() - 1);
                }
                this.mweEnc.setEnum(false, edgeId, edgeIntAccess, MaxWeightExcept.find(value));
                return;
            }
        }
        for (String restriction : HGV_RESTRICTIONS) {
            double dec;
            value = way.getTag(restriction, "");
            int atIndex = value.indexOf("@");
            if (atIndex <= 0 || Double.isNaN(dec = OSMValueExtractor.conditionalWeightToTons(value)) || OSMValueExtractor.stringToTons(way.getTag("maxweight", "")) != dec && OSMValueExtractor.stringToTons(way.getTag("maxweightrating:hgv", "")) != dec && OSMValueExtractor.stringToTons(way.getTag("maxgcweight", "")) != dec) continue;
            this.mweEnc.setEnum(false, edgeId, edgeIntAccess, MaxWeightExcept.find(value.substring(0, atIndex).trim()));
            break;
        }
    }
}

