/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntsRefEdgeIntAccess;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.BikeNetworkParserHelper;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;

public class OSMBikeNetworkTagParser
implements RelationTagParser {
    private final EnumEncodedValue<RouteNetwork> bikeRouteEnc;
    private final EnumEncodedValue<RouteNetwork> transformerRouteRelEnc = new EnumEncodedValue<RouteNetwork>(EncodingManager.getKey("bike", "route_relation"), RouteNetwork.class);

    public OSMBikeNetworkTagParser(EnumEncodedValue<RouteNetwork> bikeRouteEnc, EncodedValue.InitializerConfig relConfig) {
        this.bikeRouteEnc = bikeRouteEnc;
        this.transformerRouteRelEnc.init(relConfig);
    }

    @Override
    public void handleRelationTags(IntsRef relFlags, ReaderRelation relation) {
        IntsRefEdgeIntAccess relIntAccess = new IntsRefEdgeIntAccess(relFlags);
        RouteNetwork oldBikeNetwork = this.transformerRouteRelEnc.getEnum(false, -1, relIntAccess);
        if (relation.hasTag("route", (Object)"bicycle")) {
            String tag = Helper.toLowerCase(relation.getTag("network", ""));
            RouteNetwork newBikeNetwork = BikeNetworkParserHelper.determine(tag);
            if (oldBikeNetwork == RouteNetwork.MISSING || oldBikeNetwork.ordinal() > newBikeNetwork.ordinal()) {
                this.transformerRouteRelEnc.setEnum(false, -1, relIntAccess, newBikeNetwork);
            }
        }
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        IntsRefEdgeIntAccess relIntAccess = new IntsRefEdgeIntAccess(relationFlags);
        RouteNetwork routeNetwork = this.transformerRouteRelEnc.getEnum(false, -1, relIntAccess);
        this.bikeRouteEnc.setEnum(false, edgeId, edgeIntAccess, routeNetwork);
    }

    public EnumEncodedValue<RouteNetwork> getTransformerRouteRelEnc() {
        return this.transformerRouteRelEnc;
    }
}

