/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntsRefEdgeIntAccess;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;

public class OSMFootNetworkTagParser
implements RelationTagParser {
    private final EnumEncodedValue<RouteNetwork> footRouteEnc;
    private final EnumEncodedValue<RouteNetwork> transformerRouteRelEnc = new EnumEncodedValue<RouteNetwork>(EncodingManager.getKey("foot", "route_relation"), RouteNetwork.class);

    public OSMFootNetworkTagParser(EnumEncodedValue<RouteNetwork> footRouteEnc, EncodedValue.InitializerConfig relConfig) {
        this.footRouteEnc = footRouteEnc;
        this.transformerRouteRelEnc.init(relConfig);
    }

    @Override
    public void handleRelationTags(IntsRef relFlags, ReaderRelation relation) {
        IntsRefEdgeIntAccess relIntAccess = new IntsRefEdgeIntAccess(relFlags);
        RouteNetwork oldFootNetwork = this.transformerRouteRelEnc.getEnum(false, -1, relIntAccess);
        if (relation.hasTag("route", (Object)"hiking") || relation.hasTag("route", (Object)"foot")) {
            String tag = Helper.toLowerCase(relation.getTag("network", ""));
            RouteNetwork newFootNetwork = RouteNetwork.LOCAL;
            if ("lwn".equals(tag)) {
                newFootNetwork = RouteNetwork.LOCAL;
            } else if ("rwn".equals(tag)) {
                newFootNetwork = RouteNetwork.REGIONAL;
            } else if ("nwn".equals(tag)) {
                newFootNetwork = RouteNetwork.NATIONAL;
            } else if ("iwn".equals(tag)) {
                newFootNetwork = RouteNetwork.INTERNATIONAL;
            }
            if (oldFootNetwork == RouteNetwork.MISSING || oldFootNetwork.ordinal() > newFootNetwork.ordinal()) {
                this.transformerRouteRelEnc.setEnum(false, -1, relIntAccess, newFootNetwork);
            }
        }
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        IntsRefEdgeIntAccess relIntAccess = new IntsRefEdgeIntAccess(relationFlags);
        RouteNetwork footNetwork = this.transformerRouteRelEnc.getEnum(false, -1, relIntAccess);
        this.footRouteEnc.setEnum(false, edgeId, edgeIntAccess, footNetwork);
    }
}

