/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OSMTollParser
implements TagParser {
    private static final List<String> HGV_TAGS = Collections.unmodifiableList(Arrays.asList("toll:hgv", "toll:N2", "toll:N3"));
    private final EnumEncodedValue<Toll> tollEnc;

    public OSMTollParser(EnumEncodedValue<Toll> tollEnc) {
        this.tollEnc = tollEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay readerWay, IntsRef relationFlags) {
        Toll toll = readerWay.hasTag("toll", (Object)"yes") ? Toll.ALL : (readerWay.hasTag(HGV_TAGS, (Object)"yes") ? Toll.HGV : (readerWay.hasTag("toll", (Object)"no") ? Toll.NO : Toll.MISSING));
        if (toll == Toll.MISSING) {
            Country country = readerWay.getTag("country", Country.MISSING);
            toll = this.getCountryDefault(country, readerWay);
        }
        this.tollEnc.setEnum(false, edgeId, edgeIntAccess, toll);
    }

    private Toll getCountryDefault(Country country, ReaderWay readerWay) {
        switch (country) {
            case ROU: 
            case SVK: 
            case SVN: {
                RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
                if (roadClass == RoadClass.MOTORWAY || roadClass == RoadClass.TRUNK) {
                    return Toll.ALL;
                }
                return Toll.NO;
            }
            case CHE: {
                RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
                if (roadClass == RoadClass.MOTORWAY || roadClass == RoadClass.TRUNK) {
                    return Toll.ALL;
                }
                return Toll.HGV;
            }
            case LIE: {
                return Toll.HGV;
            }
            case HUN: {
                RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
                if (roadClass == RoadClass.MOTORWAY) {
                    return Toll.ALL;
                }
                if (roadClass == RoadClass.TRUNK || roadClass == RoadClass.PRIMARY) {
                    return Toll.HGV;
                }
                return Toll.NO;
            }
            case DEU: 
            case DNK: 
            case EST: 
            case LTU: 
            case LVA: {
                RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
                if (roadClass == RoadClass.MOTORWAY || roadClass == RoadClass.TRUNK || roadClass == RoadClass.PRIMARY) {
                    return Toll.HGV;
                }
                return Toll.NO;
            }
            case BEL: 
            case BLR: 
            case LUX: 
            case POL: 
            case SWE: {
                RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
                if (roadClass == RoadClass.MOTORWAY) {
                    return Toll.HGV;
                }
                return Toll.NO;
            }
            case BGR: 
            case CZE: 
            case FRA: 
            case GRC: 
            case HRV: 
            case ITA: 
            case PRT: 
            case SRB: 
            case ESP: {
                RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
                if (roadClass == RoadClass.MOTORWAY) {
                    return Toll.ALL;
                }
                return Toll.NO;
            }
        }
        return Toll.NO;
    }
}

