/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.weighting.WeightApproximator;

public class BalancedWeightApproximator {
    private final WeightApproximator uniDirApproximatorForward;
    private final WeightApproximator uniDirApproximatorReverse;
    double fromOffset;
    double toOffset;

    public BalancedWeightApproximator(WeightApproximator weightApprox) {
        if (weightApprox == null) {
            throw new IllegalArgumentException("WeightApproximator cannot be null");
        }
        this.uniDirApproximatorForward = weightApprox;
        this.uniDirApproximatorReverse = weightApprox.reverse();
    }

    public WeightApproximator getApproximation() {
        return this.uniDirApproximatorForward;
    }

    public void setFromTo(int from, int to) {
        this.uniDirApproximatorReverse.setTo(from);
        this.uniDirApproximatorForward.setTo(to);
        this.fromOffset = 0.5 * this.uniDirApproximatorForward.approximate(from);
        this.toOffset = 0.5 * this.uniDirApproximatorReverse.approximate(to);
    }

    public double approximate(int node, boolean reverse) {
        double weightApproximation = 0.5 * (this.uniDirApproximatorForward.approximate(node) - this.uniDirApproximatorReverse.approximate(node));
        if (reverse) {
            return this.fromOffset - weightApproximation;
        }
        return this.toOffset + weightApproximation;
    }

    public double getSlack() {
        return this.uniDirApproximatorForward.getSlack();
    }

    public String toString() {
        return this.uniDirApproximatorForward.toString();
    }
}

