/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.MinMax;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.routing.weighting.custom.ParseResult;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.Visitor;

public class ValueExpressionVisitor
implements Visitor.AtomVisitor<Boolean, Exception> {
    private static final String INFINITY = Double.toString(Double.POSITIVE_INFINITY);
    private static final Set<String> allowedMethodParents = Set.of("Math");
    private static final Set<String> allowedMethods = Set.of("sqrt");
    private final ParseResult result;
    private final NameValidator variableValidator;
    private String invalidMessage;

    public ValueExpressionVisitor(ParseResult result, NameValidator variableValidator) {
        this.result = result;
        this.variableValidator = variableValidator;
    }

    boolean isValidIdentifier(String identifier) {
        if (this.variableValidator.isValid(identifier)) {
            if (!Character.isUpperCase(identifier.charAt(0))) {
                this.result.guessedVariables.add(identifier);
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitRvalue(Java.Rvalue rv) throws Exception {
        if (rv instanceof Java.AmbiguousName) {
            Java.AmbiguousName n = (Java.AmbiguousName)rv;
            if (n.identifiers.length == 1) {
                String arg = n.identifiers[0];
                if (this.isValidIdentifier(arg)) {
                    return true;
                }
                this.invalidMessage = "'" + arg + "' not available";
                return false;
            }
            this.invalidMessage = "identifier " + String.valueOf(n) + " invalid";
            return false;
        }
        if (rv instanceof Java.Literal) {
            return true;
        }
        if (rv instanceof Java.UnaryOperation) {
            Java.UnaryOperation uop = (Java.UnaryOperation)rv;
            this.result.operators.add(uop.operator);
            if (uop.operator.equals("-")) {
                return uop.operand.accept(this);
            }
            return false;
        }
        if (rv instanceof Java.MethodInvocation) {
            Java.MethodInvocation mi = (Java.MethodInvocation)rv;
            if (allowedMethods.contains(mi.methodName) && mi.target != null) {
                Java.AmbiguousName n = (Java.AmbiguousName)mi.target.toRvalue();
                if (n.identifiers.length == 2 && allowedMethodParents.contains(n.identifiers[0])) {
                    if (mi.arguments.length == 0) {
                        this.result.guessedVariables.add(n.identifiers[0]);
                        return true;
                    }
                    if (mi.arguments.length == 1) {
                        return mi.arguments[0].accept(this);
                    }
                }
            }
            this.invalidMessage = mi.methodName + " is an illegal method in a value expression";
            return false;
        }
        if (rv instanceof Java.ParenthesizedExpression) {
            return ((Java.ParenthesizedExpression)rv).value.accept(this);
        }
        if (rv instanceof Java.BinaryOperation) {
            Java.BinaryOperation binOp = (Java.BinaryOperation)rv;
            String op = binOp.operator;
            this.result.operators.add(op);
            if (op.equals("*") || op.equals("+") || binOp.operator.equals("-")) {
                return binOp.lhs.accept(this) != false && binOp.rhs.accept(this) != false;
            }
            this.invalidMessage = "invalid operation '" + op + "'";
            return false;
        }
        return false;
    }

    @Override
    public Boolean visitPackage(Java.Package p) {
        return false;
    }

    @Override
    public Boolean visitType(Java.Type t2) {
        return false;
    }

    @Override
    public Boolean visitConstructorInvocation(Java.ConstructorInvocation ci) {
        return false;
    }

    static ParseResult parse(String expression, NameValidator variableValidator) {
        ParseResult result = new ParseResult();
        try {
            Parser parser = new Parser(new Scanner("ignore", new StringReader(expression)));
            Java.Atom atom = parser.parseConditionalExpression();
            if (parser.peek().type == TokenType.END_OF_INPUT) {
                result.guessedVariables = new LinkedHashSet<String>();
                result.operators = new LinkedHashSet<String>();
                ValueExpressionVisitor visitor = new ValueExpressionVisitor(result, variableValidator);
                result.ok = atom.accept(visitor);
                result.invalidMessage = visitor.invalidMessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static Set<String> findVariables(List<Statement> statements, EncodedValueLookup lookup) {
        List<List<Statement>> groups2 = CustomModelParser.splitIntoGroup(statements);
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        for (List<Statement> group : groups2) {
            ValueExpressionVisitor.findVariablesForGroup(variables, group, lookup);
        }
        return variables;
    }

    private static void findVariablesForGroup(Set<String> createdObjects, List<Statement> group, EncodedValueLookup lookup) {
        if (group.isEmpty() || !Statement.Keyword.IF.equals((Object)group.get(0).keyword())) {
            throw new IllegalArgumentException("Every group of statements must start with an if-statement");
        }
        Statement first = group.get(0);
        if (first.condition().trim().equals("true")) {
            if (first.isBlock()) {
                List<List<Statement>> groups2 = CustomModelParser.splitIntoGroup(first.doBlock());
                for (List<Statement> subGroup : groups2) {
                    ValueExpressionVisitor.findVariablesForGroup(createdObjects, subGroup, lookup);
                }
            } else {
                createdObjects.addAll(ValueExpressionVisitor.findVariables(first.value(), lookup));
            }
        } else {
            for (Statement st : group) {
                if (st.isBlock()) {
                    List<List<Statement>> groups3 = CustomModelParser.splitIntoGroup(st.doBlock());
                    for (List<Statement> subGroup : groups3) {
                        ValueExpressionVisitor.findVariablesForGroup(createdObjects, subGroup, lookup);
                    }
                    continue;
                }
                createdObjects.addAll(ValueExpressionVisitor.findVariables(st.value(), lookup));
            }
        }
    }

    static Set<String> findVariables(String valueExpression, EncodedValueLookup lookup) {
        double value;
        ParseResult result = ValueExpressionVisitor.parse(valueExpression, key -> lookup.hasEncodedValue(key) || key.contains(INFINITY));
        if (!result.ok) {
            throw new IllegalArgumentException(result.invalidMessage);
        }
        if (result.guessedVariables.size() > 1) {
            throw new IllegalArgumentException("Currently only a single EncodedValue is allowed on the right-hand side, but was " + result.guessedVariables.size() + ". Value expression: " + valueExpression);
        }
        try {
            value = Double.parseDouble(valueExpression);
        }
        catch (NumberFormatException ex) {
            try {
                if (result.guessedVariables.isEmpty()) {
                    NoArgEvaluator ee = new ExpressionEvaluator().createFastEvaluator(valueExpression, NoArgEvaluator.class, new String[0]);
                    value = ee.evaluate();
                } else if (lookup.hasEncodedValue(valueExpression)) {
                    EncodedValue enc = lookup.getEncodedValue(valueExpression, EncodedValue.class);
                    value = Math.min(ValueExpressionVisitor.getMin(enc), ValueExpressionVisitor.getMax(enc));
                } else {
                    String var = result.guessedVariables.iterator().next();
                    SingleArgEvaluator ee = new ExpressionEvaluator().createFastEvaluator(valueExpression, SingleArgEvaluator.class, var);
                    EncodedValue enc = lookup.getEncodedValue(var, EncodedValue.class);
                    double max = ValueExpressionVisitor.getMax(enc);
                    double val1 = ee.evaluate(max);
                    double min2 = ValueExpressionVisitor.getMin(enc);
                    double val2 = ee.evaluate(min2);
                    value = Math.min(val1, val2);
                }
            }
            catch (CompileException ex2) {
                throw new IllegalArgumentException(ex2);
            }
        }
        if (value < 0.0) {
            throw new IllegalArgumentException("illegal expression as it can result in a negative weight: " + valueExpression);
        }
        return result.guessedVariables;
    }

    static MinMax findMinMax(String valueExpression, EncodedValueLookup lookup) {
        ParseResult result = ValueExpressionVisitor.parse(valueExpression, lookup::hasEncodedValue);
        if (!result.ok) {
            throw new IllegalArgumentException(result.invalidMessage);
        }
        if (result.guessedVariables.size() > 1) {
            throw new IllegalArgumentException("Currently only a single EncodedValue is allowed on the right-hand side, but was " + result.guessedVariables.size() + ". Value expression: " + valueExpression);
        }
        try {
            double val = Double.parseDouble(valueExpression);
            return new MinMax(val, val);
        }
        catch (NumberFormatException val) {
            try {
                if (result.guessedVariables.isEmpty()) {
                    NoArgEvaluator ee = new ExpressionEvaluator().createFastEvaluator(valueExpression, NoArgEvaluator.class, new String[0]);
                    double val2 = ee.evaluate();
                    return new MinMax(val2, val2);
                }
                if (lookup.hasEncodedValue(valueExpression)) {
                    EncodedValue enc = lookup.getEncodedValue(valueExpression, EncodedValue.class);
                    double min2 = ValueExpressionVisitor.getMin(enc);
                    double max = ValueExpressionVisitor.getMax(enc);
                    return new MinMax(min2, max);
                }
                String var = result.guessedVariables.iterator().next();
                SingleArgEvaluator ee = new ExpressionEvaluator().createFastEvaluator(valueExpression, SingleArgEvaluator.class, var);
                EncodedValue enc = lookup.getEncodedValue(var, EncodedValue.class);
                double max = ValueExpressionVisitor.getMax(enc);
                double val1 = ee.evaluate(max);
                double min3 = ValueExpressionVisitor.getMin(enc);
                double val2 = ee.evaluate(min3);
                return new MinMax(Math.min(val1, val2), Math.max(val1, val2));
            }
            catch (CompileException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    static double getMin(EncodedValue enc) {
        if (enc instanceof DecimalEncodedValue) {
            return ((DecimalEncodedValue)enc).getMinStorableDecimal();
        }
        if (enc instanceof IntEncodedValue) {
            return ((IntEncodedValue)enc).getMinStorableInt();
        }
        throw new IllegalArgumentException("Cannot use non-number data '" + enc.getName() + "' in value expression");
    }

    static double getMax(EncodedValue enc) {
        if (enc instanceof DecimalEncodedValue) {
            return ((DecimalEncodedValue)enc).getMaxOrMaxStorableDecimal();
        }
        if (enc instanceof IntEncodedValue) {
            return ((IntEncodedValue)enc).getMaxOrMaxStorableInt();
        }
        throw new IllegalArgumentException("Cannot use non-number data '" + enc.getName() + "' in value expression");
    }

    protected static interface NoArgEvaluator {
        public double evaluate();
    }

    protected static interface SingleArgEvaluator {
        public double evaluate(double var1);
    }
}

