/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.Helper;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;

public abstract class AbstractDataAccess
implements DataAccess {
    protected static final int SEGMENT_SIZE_MIN = 128;
    protected static final int HEADER_OFFSET = 100;
    protected static final byte[] EMPTY = new byte[1024];
    private static final int SEGMENT_SIZE_DEFAULT = 0x100000;
    protected final ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    protected final BitUtil bitUtil = BitUtil.LITTLE;
    private final String location;
    protected int[] header = new int[20];
    protected String name;
    protected int segmentSizeInBytes;
    protected int segmentSizePower;
    protected int indexDivisor;
    protected boolean closed = false;

    public AbstractDataAccess(String name, String location, int segmentSize) {
        this.name = name;
        if (!Helper.isEmpty(location) && !location.endsWith("/")) {
            throw new IllegalArgumentException("Create DataAccess object via its corresponding Directory!");
        }
        this.location = location;
        if (segmentSize < 0) {
            segmentSize = 0x100000;
        }
        this.setSegmentSize(segmentSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getFullName() {
        return this.location + this.name;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setHeader(int bytePos, int value) {
        this.header[bytePos >>= 2] = value;
    }

    @Override
    public int getHeader(int bytePos) {
        return this.header[bytePos >>= 2];
    }

    protected void writeHeader(RandomAccessFile file, long length, int segmentSize) throws IOException {
        file.seek(0L);
        file.writeUTF("GH");
        file.writeLong(length);
        file.writeInt(segmentSize);
        for (int i = 0; i < this.header.length; ++i) {
            file.writeInt(this.header[i]);
        }
    }

    protected long readHeader(RandomAccessFile raFile) throws IOException {
        raFile.seek(0L);
        if (raFile.length() == 0L) {
            return -1L;
        }
        String versionHint = raFile.readUTF();
        if (!"GH".equals(versionHint)) {
            throw new IllegalArgumentException("Not a GraphHopper file " + this.getFullName() + "! Expected 'GH' as file marker but was " + versionHint);
        }
        long bytes = raFile.readLong();
        this.setSegmentSize(raFile.readInt());
        for (int i = 0; i < this.header.length; ++i) {
            this.header[i] = raFile.readInt();
        }
        return bytes;
    }

    protected void copyHeader(DataAccess da) {
        for (int h2 = 0; h2 < this.header.length * 4; h2 += 4) {
            da.setHeader(h2, this.getHeader(h2));
        }
    }

    DataAccess setSegmentSize(int bytes) {
        if (bytes > 0) {
            int tmp = (int)(Math.log(bytes) / Math.log(2.0));
            this.segmentSizeInBytes = Math.max((int)Math.pow(2.0, tmp), 128);
        }
        this.segmentSizePower = (int)(Math.log(this.segmentSizeInBytes) / Math.log(2.0));
        this.indexDivisor = this.segmentSizeInBytes - 1;
        return this;
    }

    @Override
    public int getSegmentSize() {
        return this.segmentSizeInBytes;
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean isStoring() {
        return true;
    }

    protected boolean isIntBased() {
        return false;
    }
}

