/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;

public class RAMDataAccess
extends AbstractDataAccess {
    private byte[][] segments = new byte[0][];
    private boolean store;
    private static final VarHandle INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN).withInvokeExactBehavior();
    private static final VarHandle SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN).withInvokeExactBehavior();

    RAMDataAccess(String name, String location, boolean store, int segmentSize) {
        super(name, location, segmentSize);
        this.store = store;
    }

    public RAMDataAccess store(boolean store) {
        this.store = store;
        return this;
    }

    @Override
    public boolean isStoring() {
        return this.store;
    }

    @Override
    public RAMDataAccess create(long bytes) {
        if (this.segments.length > 0) {
            throw new IllegalThreadStateException("already created");
        }
        this.ensureCapacity(Math.max(40L, bytes));
        return this;
    }

    @Override
    public boolean ensureCapacity(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("new capacity has to be strictly positive");
        }
        long cap = this.getCapacity();
        long newBytes = bytes - cap;
        if (newBytes <= 0L) {
            return false;
        }
        int segmentsToCreate = (int)(newBytes / (long)this.segmentSizeInBytes);
        if (newBytes % (long)this.segmentSizeInBytes != 0L) {
            ++segmentsToCreate;
        }
        try {
            byte[][] newSegs = (byte[][])Arrays.copyOf(this.segments, this.segments.length + segmentsToCreate);
            for (int i = this.segments.length; i < newSegs.length; ++i) {
                newSegs[i] = new byte[1 << this.segmentSizePower];
            }
            this.segments = newSegs;
        }
        catch (OutOfMemoryError err) {
            throw new OutOfMemoryError(err.getMessage() + " - problem when allocating new memory. Old capacity: " + cap + ", new bytes:" + newBytes + ", segmentSizeIntsPower:" + this.segmentSizePower + ", new segments:" + segmentsToCreate + ", existing:" + this.segments.length);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadExisting() {
        if (this.segments.length > 0) {
            throw new IllegalStateException("already initialized");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("already closed");
        }
        if (!this.store) {
            return false;
        }
        File file = new File(this.getFullName());
        if (!file.exists()) return false;
        if (file.length() == 0L) {
            return false;
        }
        try (RandomAccessFile raFile = new RandomAccessFile(this.getFullName(), "r");){
            long byteCount = this.readHeader(raFile) - 100L;
            if (byteCount < 0L) {
                boolean bl = false;
                return bl;
            }
            raFile.seek(100L);
            int segmentCount = (int)(byteCount / (long)this.segmentSizeInBytes);
            if (byteCount % (long)this.segmentSizeInBytes != 0L) {
                ++segmentCount;
            }
            this.segments = new byte[segmentCount][];
            for (int s2 = 0; s2 < segmentCount; ++s2) {
                byte[] bytes = new byte[this.segmentSizeInBytes];
                int read = raFile.read(bytes);
                if (read <= 0) {
                    throw new IllegalStateException("segment " + s2 + " is empty? " + this.toString());
                }
                this.segments[s2] = bytes;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException("Problem while loading " + this.getFullName(), ex);
        }
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        if (!this.store) {
            return;
        }
        try (RandomAccessFile raFile = new RandomAccessFile(this.getFullName(), "rw");){
            long len = this.getCapacity();
            this.writeHeader(raFile, len, this.segmentSizeInBytes);
            raFile.seek(100L);
            for (int s2 = 0; s2 < this.segments.length; ++s2) {
                byte[] area = this.segments[s2];
                raFile.write(area);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't store bytes to " + this.toString(), ex);
        }
    }

    @Override
    public final void setInt(long bytePos, int value) {
        assert (this.segmentSizePower > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        if (index + 3 >= this.segmentSizeInBytes) {
            byte[] b1 = this.segments[bufferIndex];
            byte[] b2 = this.segments[bufferIndex + 1];
            if (index + 1 >= this.segmentSizeInBytes) {
                this.bitUtil.fromUInt3(b2, value >>> 8, 0);
                b1[index] = (byte)value;
            } else if (index + 2 >= this.segmentSizeInBytes) {
                this.bitUtil.fromShort(b2, (short)(value >>> 16), 0);
                this.bitUtil.fromShort(b1, (short)value, index);
            } else {
                b2[0] = (byte)(value >>> 24);
                this.bitUtil.fromUInt3(b1, value, index);
            }
        } else {
            INT.set(this.segments[bufferIndex], index, value);
        }
    }

    @Override
    public final int getInt(long bytePos) {
        assert (this.segments.length > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        if (index + 3 >= this.segmentSizeInBytes) {
            byte[] b1 = this.segments[bufferIndex];
            byte[] b2 = this.segments[bufferIndex + 1];
            if (index + 1 >= this.segmentSizeInBytes) {
                return (b2[2] & 0xFF) << 24 | (b2[1] & 0xFF) << 16 | (b2[0] & 0xFF) << 8 | b1[index] & 0xFF;
            }
            if (index + 2 >= this.segmentSizeInBytes) {
                return (b2[1] & 0xFF) << 24 | (b2[0] & 0xFF) << 16 | (b1[index + 1] & 0xFF) << 8 | b1[index] & 0xFF;
            }
            return (b2[0] & 0xFF) << 24 | (b1[index + 2] & 0xFF) << 16 | (b1[index + 1] & 0xFF) << 8 | b1[index] & 0xFF;
        }
        return INT.get(this.segments[bufferIndex], index);
    }

    @Override
    public final void setShort(long bytePos, short value) {
        assert (this.segments.length > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        if (index + 1 >= this.segmentSizeInBytes) {
            this.segments[bufferIndex][index] = (byte)value;
            this.segments[bufferIndex + 1][0] = (byte)(value >>> 8);
        } else {
            SHORT.set(this.segments[bufferIndex], index, value);
        }
    }

    @Override
    public final short getShort(long bytePos) {
        assert (this.segments.length > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        if (index + 1 >= this.segmentSizeInBytes) {
            return (short)((this.segments[bufferIndex + 1][0] & 0xFF) << 8 | this.segments[bufferIndex][index] & 0xFF);
        }
        return SHORT.get(this.segments[bufferIndex], index);
    }

    @Override
    public void setBytes(long bytePos, byte[] values2, int length) {
        assert (length <= this.segmentSizeInBytes) : "the length has to be smaller or equal to the segment size: " + length + " vs. " + this.segmentSizeInBytes;
        assert (this.segments.length > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        byte[] seg = this.segments[bufferIndex];
        int delta = index + length - this.segmentSizeInBytes;
        if (delta > 0) {
            System.arraycopy(values2, 0, seg, index, length -= delta);
            seg = this.segments[bufferIndex + 1];
            System.arraycopy(values2, length, seg, 0, delta);
        } else {
            System.arraycopy(values2, 0, seg, index, length);
        }
    }

    @Override
    public void getBytes(long bytePos, byte[] values2, int length) {
        assert (length <= this.segmentSizeInBytes) : "the length has to be smaller or equal to the segment size: " + length + " vs. " + this.segmentSizeInBytes;
        assert (this.segments.length > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        byte[] seg = this.segments[bufferIndex];
        int delta = index + length - this.segmentSizeInBytes;
        if (delta > 0) {
            System.arraycopy(seg, index, values2, 0, length -= delta);
            seg = this.segments[bufferIndex + 1];
            System.arraycopy(seg, 0, values2, length, delta);
        } else {
            System.arraycopy(seg, index, values2, 0, length);
        }
    }

    @Override
    public final void setByte(long bytePos, byte value) {
        assert (this.segments.length > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        this.segments[bufferIndex][index] = value;
    }

    @Override
    public final byte getByte(long bytePos) {
        assert (this.segments.length > 0) : "call create or loadExisting before usage!";
        int bufferIndex = (int)(bytePos >>> this.segmentSizePower);
        int index = (int)(bytePos & (long)this.indexDivisor);
        return this.segments[bufferIndex][index];
    }

    @Override
    public void close() {
        super.close();
        this.segments = new byte[0][];
        this.closed = true;
    }

    @Override
    public long getCapacity() {
        return (long)this.getSegments() * (long)this.segmentSizeInBytes;
    }

    @Override
    public int getSegments() {
        return this.segments.length;
    }

    @Override
    public DAType getType() {
        if (this.isStoring()) {
            return DAType.RAM_STORE;
        }
        return DAType.RAM;
    }
}

