/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.geohash.SpatialKeyAlgo;
import com.graphhopper.storage.index.IndexStructureInfo;
import com.graphhopper.storage.index.PixelGridTraversal;
import com.graphhopper.util.DistancePlaneProjection;
import org.locationtech.jts.geom.Coordinate;

public class InMemConstructionIndex {
    final PixelGridTraversal pixelGridTraversal;
    final SpatialKeyAlgo keyAlgo;
    final int[] entries;
    final byte[] shifts;
    final InMemTreeEntry root;

    public InMemConstructionIndex(IndexStructureInfo indexStructureInfo) {
        this.root = new InMemTreeEntry(indexStructureInfo.getEntries()[0]);
        this.entries = indexStructureInfo.getEntries();
        this.shifts = indexStructureInfo.getShifts();
        this.pixelGridTraversal = indexStructureInfo.getPixelGridTraversal();
        this.keyAlgo = indexStructureInfo.getKeyAlgo();
    }

    public void addToAllTilesOnLine(int value, double lat1, double lon1, double lat2, double lon2) {
        if (!DistancePlaneProjection.DIST_PLANE.isCrossBoundary(lon1, lon2)) {
            this.pixelGridTraversal.traverse(new Coordinate(lon1, lat1), new Coordinate(lon2, lat2), p -> {
                long key = this.keyAlgo.encode((int)p.x, (int)p.y);
                this.put(key, value);
            });
        }
    }

    void put(long key, int value) {
        this.put(key << 64 - this.keyAlgo.getBits(), this.root, 0, value);
    }

    private void put(long keyPart, InMemEntry entry, int depth, int value) {
        if (entry.isLeaf()) {
            InMemLeafEntry leafEntry = (InMemLeafEntry)entry;
            if (leafEntry.isEmpty() || leafEntry.get(leafEntry.size() - 1) != value) {
                leafEntry.add(value);
            }
        } else {
            int index = (int)(keyPart >>> 64 - this.shifts[depth]);
            keyPart <<= this.shifts[depth];
            InMemTreeEntry treeEntry = (InMemTreeEntry)entry;
            InMemEntry subentry = treeEntry.getSubEntry(index);
            ++depth;
            if (subentry == null) {
                subentry = depth == this.entries.length ? new InMemLeafEntry(4) : new InMemTreeEntry(this.entries[depth]);
                treeEntry.setSubEntry(index, subentry);
            }
            this.put(keyPart, subentry, depth, value);
        }
    }

    static class InMemTreeEntry
    implements InMemEntry {
        InMemEntry[] subEntries;

        public InMemTreeEntry(int subEntryNo) {
            this.subEntries = new InMemEntry[subEntryNo];
        }

        public InMemEntry getSubEntry(int index) {
            return this.subEntries[index];
        }

        public void setSubEntry(int index, InMemEntry subEntry) {
            this.subEntries[index] = subEntry;
        }

        @Override
        public final boolean isLeaf() {
            return false;
        }

        public String toString() {
            return "TREE";
        }
    }

    static interface InMemEntry {
        public boolean isLeaf();
    }

    static class InMemLeafEntry
    extends IntArrayList
    implements InMemEntry {
        public InMemLeafEntry(int count) {
            super(count);
        }

        @Override
        public final boolean isLeaf() {
            return true;
        }

        @Override
        public String toString() {
            return "LEAF  " + super.toString();
        }

        IntArrayList getResults() {
            return this;
        }
    }
}

