/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.carrotsearch.hppc.IntHashSet;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.InMemConstructionIndex;
import com.graphhopper.storage.index.IndexStructureInfo;
import com.graphhopper.storage.index.LineIntIndex;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.BBox;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationIndexTree
implements LocationIndex {
    private final Directory directory;
    private final Graph graph;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NodeAccess nodeAccess;
    private int maxRegionSearch = 4;
    private int minResolutionInMeter = 300;
    private boolean initialized = false;
    LineIntIndex lineIntIndex;
    private final double equalNormedDelta = DistancePlaneProjection.DIST_PLANE.calcNormalizedDist(0.1);
    private IndexStructureInfo indexStructureInfo;

    public LocationIndexTree(Graph g2, Directory dir) {
        this.graph = g2;
        this.nodeAccess = g2.getNodeAccess();
        this.directory = dir;
        BBox bounds = this.graph.getBounds().clone();
        if (!bounds.isValid()) {
            bounds = new BBox(-10.0, 10.0, -10.0, 10.0);
        }
        this.lineIntIndex = new LineIntIndex(bounds, this.directory, "location_index");
    }

    public int getMinResolutionInMeter() {
        return this.minResolutionInMeter;
    }

    public LocationIndexTree setMinResolutionInMeter(int minResolutionInMeter) {
        this.minResolutionInMeter = minResolutionInMeter;
        return this;
    }

    public LocationIndexTree setMaxRegionSearch(int numTiles) {
        if (numTiles < 1) {
            throw new IllegalArgumentException("Region of location index must be at least 1 but was " + numTiles);
        }
        this.maxRegionSearch = numTiles;
        return this;
    }

    public LocationIndex setResolution(int minResolutionInMeter) {
        if (minResolutionInMeter <= 0) {
            throw new IllegalStateException("Negative precision is not allowed!");
        }
        this.setMinResolutionInMeter(minResolutionInMeter);
        return this;
    }

    public boolean loadExisting() {
        if (!this.lineIntIndex.loadExisting()) {
            return false;
        }
        if (this.lineIntIndex.getChecksum() != this.checksum()) {
            throw new IllegalStateException("location index was opened with incorrect graph: " + this.lineIntIndex.getChecksum() + " vs. " + this.checksum());
        }
        this.minResolutionInMeter = this.lineIntIndex.getMinResolutionInMeter();
        this.indexStructureInfo = IndexStructureInfo.create(this.graph.getBounds(), this.minResolutionInMeter);
        this.initialized = true;
        return true;
    }

    public void flush() {
        this.lineIntIndex.flush();
    }

    public LocationIndex prepareIndex() {
        return this.prepareIndex(EdgeFilter.ALL_EDGES);
    }

    public LocationIndex prepareIndex(EdgeFilter edgeFilter) {
        if (this.initialized) {
            throw new IllegalStateException("Call prepareIndex only once");
        }
        StopWatch sw = new StopWatch().start();
        BBox bounds = this.graph.getBounds().clone();
        if (!bounds.isValid()) {
            bounds = new BBox(-10.0, 10.0, -10.0, 10.0);
        }
        InMemConstructionIndex inMemConstructionIndex = this.prepareInMemConstructionIndex(bounds, edgeFilter);
        this.lineIntIndex.setMinResolutionInMeter(this.minResolutionInMeter);
        this.lineIntIndex.store(inMemConstructionIndex);
        this.lineIntIndex.setChecksum(this.checksum());
        this.flush();
        this.logger.info("location index created in " + sw.stop().getSeconds() + "s, size:" + Helper.nf(this.lineIntIndex.getSize()) + ", leafs:" + Helper.nf(this.lineIntIndex.getLeafs()) + ", precision:" + this.minResolutionInMeter + ", depth:" + this.indexStructureInfo.getEntries().length + ", checksum:" + this.checksum() + ", entries:" + Arrays.toString(this.indexStructureInfo.getEntries()) + ", entriesPerLeaf:" + (float)this.lineIntIndex.getSize() / (float)this.lineIntIndex.getLeafs());
        return this;
    }

    InMemConstructionIndex prepareInMemConstructionIndex(BBox bounds, EdgeFilter edgeFilter) {
        this.indexStructureInfo = IndexStructureInfo.create(bounds, this.minResolutionInMeter);
        InMemConstructionIndex inMem = new InMemConstructionIndex(this.indexStructureInfo);
        AllEdgesIterator allIter = this.graph.getAllEdges();
        try {
            while (allIter.next()) {
                double lon2;
                double lat2;
                if (!edgeFilter.accept(allIter)) continue;
                int edge = allIter.getEdge();
                int nodeA = allIter.getBaseNode();
                int nodeB = allIter.getAdjNode();
                double lat1 = this.nodeAccess.getLat(nodeA);
                double lon1 = this.nodeAccess.getLon(nodeA);
                PointList points = allIter.fetchWayGeometry(FetchMode.PILLAR_ONLY);
                int len = points.size();
                for (int i = 0; i < len; ++i) {
                    lat2 = points.getLat(i);
                    lon2 = points.getLon(i);
                    inMem.addToAllTilesOnLine(edge, lat1, lon1, lat2, lon2);
                    lat1 = lat2;
                    lon1 = lon2;
                }
                lat2 = this.nodeAccess.getLat(nodeB);
                lon2 = this.nodeAccess.getLon(nodeB);
                inMem.addToAllTilesOnLine(edge, lat1, lon1, lat2, lon2);
            }
        }
        catch (Exception ex1) {
            this.logger.error("Problem! base:" + allIter.getBaseNode() + ", adj:" + allIter.getAdjNode() + ", edge:" + allIter.getEdge(), ex1);
        }
        return inMem;
    }

    int checksum() {
        return this.graph.getNodes() ^ this.graph.getAllEdges().length();
    }

    @Override
    public void close() {
        this.lineIntIndex.close();
    }

    public boolean isClosed() {
        return this.lineIntIndex.isClosed();
    }

    public long getCapacity() {
        return this.lineIntIndex.getCapacity();
    }

    final double calculateRMin(double lat, double lon, int paddingTiles) {
        int x = this.indexStructureInfo.getKeyAlgo().x(lon);
        int y = this.indexStructureInfo.getKeyAlgo().y(lat);
        double minLat = this.graph.getBounds().minLat + (double)(y - paddingTiles) * this.indexStructureInfo.getDeltaLat();
        double maxLat = this.graph.getBounds().minLat + (double)(y + paddingTiles + 1) * this.indexStructureInfo.getDeltaLat();
        double minLon = this.graph.getBounds().minLon + (double)(x - paddingTiles) * this.indexStructureInfo.getDeltaLon();
        double maxLon = this.graph.getBounds().minLon + (double)(x + paddingTiles + 1) * this.indexStructureInfo.getDeltaLon();
        double dSouthernLat = lat - minLat;
        double dNorthernLat = maxLat - lat;
        double dWesternLon = lon - minLon;
        double dEasternLon = maxLon - lon;
        double dMinLat = dSouthernLat < dNorthernLat ? DistancePlaneProjection.DIST_PLANE.calcDist(lat, lon, minLat, lon) : DistancePlaneProjection.DIST_PLANE.calcDist(lat, lon, maxLat, lon);
        double dMinLon = dWesternLon < dEasternLon ? DistancePlaneProjection.DIST_PLANE.calcDist(lat, lon, lat, minLon) : DistancePlaneProjection.DIST_PLANE.calcDist(lat, lon, lat, maxLon);
        return Math.min(dMinLat, dMinLon);
    }

    @Override
    public Snap findClosest(double queryLat, double queryLon, EdgeFilter edgeFilter) {
        if (this.isClosed()) {
            throw new IllegalStateException("You need to create a new LocationIndex instance as it is already closed");
        }
        Snap closestMatch = new Snap(queryLat, queryLon);
        IntHashSet seenEdges = new IntHashSet();
        for (int iteration = 0; iteration < this.maxRegionSearch; ++iteration) {
            this.lineIntIndex.findEdgeIdsInNeighborhood(queryLat, queryLon, iteration, edgeId -> {
                EdgeIteratorState edgeIteratorState = this.graph.getEdgeIteratorStateForKey(edgeId * 2);
                if (seenEdges.add(edgeId) && edgeFilter.accept(edgeIteratorState)) {
                    this.traverseEdge(queryLat, queryLon, edgeIteratorState, (node, normedDist, wayIndex, pos) -> {
                        if (normedDist < closestMatch.getQueryDistance()) {
                            closestMatch.setQueryDistance(normedDist);
                            closestMatch.setClosestNode(node);
                            closestMatch.setClosestEdge(edgeIteratorState.detach(false));
                            closestMatch.setWayIndex(wayIndex);
                            closestMatch.setSnappedPosition(pos);
                        }
                    });
                }
            });
            if (!closestMatch.isValid()) continue;
            double rMin = this.calculateRMin(queryLat, queryLon, iteration);
            double minDistance = DistancePlaneProjection.DIST_PLANE.calcDenormalizedDist(closestMatch.getQueryDistance());
            if (minDistance < rMin) break;
        }
        if (closestMatch.isValid()) {
            closestMatch.calcSnappedPoint(DistancePlaneProjection.DIST_PLANE);
            closestMatch.setQueryDistance(DistancePlaneProjection.DIST_PLANE.calcDist(closestMatch.getSnappedPoint().lat, closestMatch.getSnappedPoint().lon, queryLat, queryLon));
        }
        return closestMatch;
    }

    @Override
    public void query(LocationIndex.TileFilter tileFilter, LocationIndex.Visitor function) {
        this.lineIntIndex.query(tileFilter, function);
    }

    public void traverseEdge(double queryLat, double queryLon, EdgeIteratorState currEdge, EdgeCheck edgeCheck) {
        double closestDist;
        int closestTowerNode;
        int baseNode = currEdge.getBaseNode();
        double baseLat = this.nodeAccess.getLat(baseNode);
        double baseLon = this.nodeAccess.getLon(baseNode);
        double baseDist = DistancePlaneProjection.DIST_PLANE.calcNormalizedDist(queryLat, queryLon, baseLat, baseLon);
        int adjNode = currEdge.getAdjNode();
        double adjLat = this.nodeAccess.getLat(adjNode);
        double adjLon = this.nodeAccess.getLon(adjNode);
        double adjDist = DistancePlaneProjection.DIST_PLANE.calcNormalizedDist(queryLat, queryLon, adjLat, adjLon);
        PointList pointList = currEdge.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ);
        int len = pointList.size();
        if (baseDist < adjDist) {
            closestTowerNode = baseNode;
            closestDist = baseDist;
            edgeCheck.check(baseNode, baseDist, 0, Snap.Position.TOWER);
        } else {
            closestTowerNode = adjNode;
            closestDist = adjDist;
            edgeCheck.check(adjNode, adjDist, len, Snap.Position.TOWER);
        }
        if (closestDist <= this.equalNormedDelta) {
            return;
        }
        double lastLat = baseLat;
        double lastLon = baseLon;
        for (int i = 0; i < len; ++i) {
            double lat = pointList.getLat(i);
            double lon = pointList.getLon(i);
            if (DistancePlaneProjection.DIST_PLANE.isCrossBoundary(lastLon, lon)) {
                lastLat = lat;
                lastLon = lon;
                continue;
            }
            int indexInFullPointList = i + 1;
            if (DistancePlaneProjection.DIST_PLANE.validEdgeDistance(queryLat, queryLon, lastLat, lastLon, lat, lon)) {
                closestDist = DistancePlaneProjection.DIST_PLANE.calcNormalizedEdgeDistance(queryLat, queryLon, lastLat, lastLon, lat, lon);
                edgeCheck.check(closestTowerNode, closestDist, indexInFullPointList - 1, Snap.Position.EDGE);
            } else if (i < len - 1) {
                closestDist = DistancePlaneProjection.DIST_PLANE.calcNormalizedDist(queryLat, queryLon, lat, lon);
                edgeCheck.check(closestTowerNode, closestDist, indexInFullPointList, Snap.Position.PILLAR);
            }
            if (closestDist <= this.equalNormedDelta) {
                return;
            }
            lastLat = lat;
            lastLon = lon;
        }
    }

    public static interface EdgeCheck {
        public void check(int var1, double var2, int var4, Snap.Position var5);
    }
}

