/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MiniPerfTest {
    private static final double NS_PER_S = 1.0E9;
    private static final double NS_PER_MS = 1000000.0;
    private static final double NS_PER_US = 1000.0;
    private int counts = 100;
    private long fullTime = 0L;
    private long max;
    private long min = Long.MAX_VALUE;
    private int dummySum;

    public MiniPerfTest start(Task m4) {
        int warmupCount = Math.max(1, this.counts / 3);
        for (int i = 0; i < warmupCount; ++i) {
            this.dummySum += m4.doCalc(true, i);
        }
        long startFull = System.nanoTime();
        for (int i = 0; i < this.counts; ++i) {
            long start = System.nanoTime();
            this.dummySum += m4.doCalc(false, i);
            long time = System.nanoTime() - start;
            if (time < this.min) {
                this.min = time;
            }
            if (time <= this.max) continue;
            this.max = time;
        }
        this.fullTime = System.nanoTime() - startFull;
        return this;
    }

    public MiniPerfTest setIterations(int counts) {
        this.counts = counts;
        return this;
    }

    public double getMin() {
        return (double)this.min / 1000000.0;
    }

    public double getMax() {
        return (double)this.max / 1000000.0;
    }

    public double getSum() {
        return (double)this.fullTime / 1000000.0;
    }

    public double getMean() {
        return this.getSum() / (double)this.counts;
    }

    private String formatDuration(double durationNs) {
        String unit;
        double divisor;
        if (durationNs > 1.0E7) {
            divisor = 1.0E9;
            unit = "s";
        } else if (durationNs > 10000.0) {
            divisor = 1000000.0;
            unit = "ms";
        } else {
            divisor = 1000.0;
            unit = "\u00b5s";
        }
        return this.nf(durationNs / divisor) + unit;
    }

    public String getReport() {
        double meanNs = (double)this.fullTime / (double)this.counts;
        return "sum:" + this.formatDuration(this.fullTime) + ", time/call:" + this.formatDuration(meanNs) + ", dummy: " + this.dummySum;
    }

    public int getDummySum() {
        return this.dummySum;
    }

    private String nf(Number num) {
        return new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ROOT)).format(num);
    }

    public static interface Task {
        public int doCalc(boolean var1, int var2);
    }
}

