/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.ResponsePath;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PathSimplification;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RamerDouglasPeucker;
import com.graphhopper.util.Translation;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.details.PathDetailsFromEdges;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PathMerger {
    private static final RamerDouglasPeucker RDP = new RamerDouglasPeucker();
    private final Graph graph;
    private final Weighting weighting;
    private boolean enableInstructions = true;
    private boolean simplifyResponse = true;
    private RamerDouglasPeucker ramerDouglasPeucker = RDP;
    private boolean calcPoints = true;
    private PathDetailsBuilderFactory pathBuilderFactory;
    private List<String> requestedPathDetails = Collections.emptyList();
    private double favoredHeading = Double.NaN;

    public PathMerger(Graph graph, Weighting weighting) {
        this.graph = graph;
        this.weighting = graph.wrapWeighting(weighting);
    }

    public PathMerger setCalcPoints(boolean calcPoints) {
        this.calcPoints = calcPoints;
        return this;
    }

    public PathMerger setRamerDouglasPeucker(RamerDouglasPeucker ramerDouglasPeucker) {
        this.ramerDouglasPeucker = ramerDouglasPeucker;
        return this;
    }

    public PathMerger setPathDetailsBuilders(PathDetailsBuilderFactory pathBuilderFactory, List<String> requestedPathDetails) {
        this.pathBuilderFactory = pathBuilderFactory;
        this.requestedPathDetails = requestedPathDetails;
        return this;
    }

    public PathMerger setSimplifyResponse(boolean simplifyRes) {
        this.simplifyResponse = simplifyRes;
        return this;
    }

    public PathMerger setEnableInstructions(boolean enableInstructions) {
        this.enableInstructions = enableInstructions;
        return this;
    }

    public ResponsePath doWork(PointList waypoints, List<Path> paths, EncodedValueLookup evLookup, Translation tr) {
        ResponsePath responsePath = new ResponsePath();
        int origPoints = 0;
        long fullTimeInMillis = 0L;
        double fullWeight = 0.0;
        double fullDistance = 0.0;
        boolean allFound = true;
        InstructionList fullInstructions = new InstructionList(tr);
        PointList fullPoints = PointList.EMPTY;
        ArrayList<String> description = new ArrayList<String>();
        ArrayList<Integer> wayPointIndices = new ArrayList<Integer>();
        for (int pathIndex = 0; pathIndex < paths.size(); ++pathIndex) {
            InstructionList il;
            Path path = paths.get(pathIndex);
            if (!path.isFound()) {
                allFound = false;
                continue;
            }
            description.addAll(path.getDescription());
            fullTimeInMillis += path.getTime();
            fullDistance += path.getDistance();
            fullWeight += path.getWeight();
            if (this.enableInstructions && !(il = InstructionsFromEdges.calcInstructions(path, this.graph, this.weighting, evLookup, tr)).isEmpty()) {
                fullInstructions.addAll(il);
                if (pathIndex + 1 < paths.size()) {
                    ViaInstruction newInstr = new ViaInstruction(fullInstructions.get(fullInstructions.size() - 1));
                    newInstr.setViaCount(pathIndex + 1);
                    fullInstructions.set(fullInstructions.size() - 1, newInstr);
                }
            }
            if (this.calcPoints || this.enableInstructions) {
                PointList tmpPoints = path.calcPoints();
                if (fullPoints.isEmpty()) {
                    fullPoints = new PointList(tmpPoints.size(), tmpPoints.is3D());
                }
                if (pathIndex + 1 < paths.size()) {
                    tmpPoints.removeLastPoint();
                }
                fullPoints.add(tmpPoints);
                responsePath.addPathDetails(PathDetailsFromEdges.calcDetails(path, evLookup, this.weighting, this.requestedPathDetails, this.pathBuilderFactory, origPoints, this.graph));
                wayPointIndices.add(origPoints);
                if (pathIndex == paths.size() - 1) {
                    wayPointIndices.add(fullPoints.size() - 1);
                }
                origPoints = fullPoints.size();
            }
            allFound = allFound && path.isFound();
        }
        if (!fullPoints.isEmpty() && fullPoints.is3D) {
            this.calcAscendDescend(responsePath, fullPoints);
        }
        if (this.enableInstructions) {
            fullInstructions = this.updateInstructionsWithContext(fullInstructions);
            responsePath.setInstructions(fullInstructions);
        }
        if (!allFound) {
            responsePath.addError(new ConnectionNotFoundException("Connection between locations not found", Collections.emptyMap()));
        }
        if (allFound && !waypoints.isEmpty()) {
            for (int i = 0; i < wayPointIndices.size(); ++i) {
                int index = (Integer)wayPointIndices.get(i);
                if (waypoints.getLat(i) == fullPoints.getLat(index) && waypoints.getLon(i) == fullPoints.getLon(index)) continue;
                throw new IllegalStateException("waypoints are not included in points, or waypoint indices are wrong");
            }
        }
        responsePath.setDescription(description).setPoints(fullPoints).setRouteWeight(fullWeight).setDistance(fullDistance).setTime(fullTimeInMillis).setWaypoints(waypoints).setWaypointIndices(wayPointIndices);
        if (allFound && this.simplifyResponse && (this.calcPoints || this.enableInstructions)) {
            PathSimplification.simplify(responsePath, this.ramerDouglasPeucker, this.enableInstructions);
        }
        return responsePath;
    }

    private InstructionList updateInstructionsWithContext(InstructionList instructions) {
        for (int i = 0; i < instructions.size() - 1; ++i) {
            double heading;
            double lastHeading;
            double diff;
            Instruction nextInstruction;
            double heading2;
            double diff2;
            Instruction instruction = instructions.get(i);
            if (i == 0 && !Double.isNaN(this.favoredHeading) && instruction.extraInfo.containsKey("heading") && (diff2 = Math.abs((heading2 = ((Double)instruction.extraInfo.get("heading")).doubleValue()) - this.favoredHeading) % 360.0) > 170.0 && diff2 < 190.0) {
                instruction.setSign(-98);
            }
            if (instruction.getSign() != 5 || (nextInstruction = instructions.get(i + 1)).getSign() != 0 || !instruction.extraInfo.containsKey("last_heading") || !nextInstruction.extraInfo.containsKey("heading") || !((diff = Math.abs((lastHeading = ((Double)instruction.extraInfo.get("last_heading")).doubleValue()) - (heading = ((Double)nextInstruction.extraInfo.get("heading")).doubleValue())) % 360.0) > 179.0) || !(diff < 181.0)) continue;
            nextInstruction.setSign(-98);
        }
        return instructions;
    }

    private void calcAscendDescend(ResponsePath responsePath, PointList pointList) {
        double ascendMeters = 0.0;
        double descendMeters = 0.0;
        double lastEle = pointList.getEle(0);
        for (int i = 1; i < pointList.size(); ++i) {
            double ele = pointList.getEle(i);
            double diff = Math.abs(ele - lastEle);
            if (ele > lastEle) {
                ascendMeters += diff;
            } else {
                descendMeters += diff;
            }
            lastEle = ele;
        }
        responsePath.setAscend(ascendMeters);
        responsePath.setDescend(descendMeters);
    }

    public void setFavoredHeading(double favoredHeading) {
        this.favoredHeading = favoredHeading;
    }
}

