/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;

public class StopWatch {
    private long lastTime;
    private long elapsedNanos;
    private String name = "";

    public StopWatch(String name) {
        this.name = name;
    }

    public StopWatch() {
    }

    public static StopWatch started() {
        return StopWatch.started("");
    }

    public static StopWatch started(String name) {
        return new StopWatch(name).start();
    }

    public StopWatch setName(String name) {
        this.name = name;
        return this;
    }

    public StopWatch start() {
        this.lastTime = System.nanoTime();
        return this;
    }

    public StopWatch stop() {
        if (this.lastTime < 0L) {
            return this;
        }
        this.elapsedNanos += System.nanoTime() - this.lastTime;
        this.lastTime = -1L;
        return this;
    }

    public float getSeconds() {
        return (float)this.elapsedNanos / 1.0E9f;
    }

    public float getCurrentSeconds() {
        if (this.notStarted()) {
            return 0.0f;
        }
        long lastNanos = this.lastTime < 0L ? 0L : System.nanoTime() - this.lastTime;
        return (float)(this.elapsedNanos + lastNanos) / 1.0E9f;
    }

    public long getMillis() {
        return this.elapsedNanos / 1000000L;
    }

    public double getMillisDouble() {
        return (double)this.elapsedNanos / 1000000.0;
    }

    public long getNanos() {
        return this.elapsedNanos;
    }

    public String toString() {
        Object str = "";
        if (!Helper.isEmpty(this.name)) {
            str = (String)str + this.name + " ";
        }
        return (String)str + "time:" + this.getSeconds() + "s";
    }

    public String getTimeString() {
        if ((double)this.elapsedNanos < 1000.0) {
            return this.elapsedNanos + "ns";
        }
        if ((double)this.elapsedNanos < 1000000.0) {
            return String.format("%.2f\u00b5s", (double)this.elapsedNanos / 1000.0);
        }
        if ((double)this.elapsedNanos < 1.0E9) {
            return String.format("%.2fms", (double)this.elapsedNanos / 1000000.0);
        }
        double seconds = (double)this.elapsedNanos / 1.0E9;
        if (seconds < 60.0) {
            return String.format("%.2fs", (double)this.elapsedNanos / 1.0E9);
        }
        if (seconds < 3600.0) {
            return String.format("%dmin %ds", (int)seconds / 60, (int)seconds % 60);
        }
        return String.format("%dh %dmin", (int)seconds / 3600, (int)seconds % 3600 / 60);
    }

    private boolean notStarted() {
        return this.lastTime == 0L && this.elapsedNanos == 0L;
    }
}

