/*
 * Decompiled with CFR 0.152.
 */
package com.papertrail.profiler;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class CpuProfile {
    private final Map<List<StackTraceElement>, Long> m_counts;
    public final Duration m_duration;
    public final long m_count;
    public final long m_missed;
    private static final Set<StringPair> idleClassAndMethod = new HashSet<StringPair>();

    public CpuProfile(Map<List<StackTraceElement>, Long> map, Duration duration, long l, long l2) {
        this.m_counts = map;
        this.m_duration = duration;
        this.m_count = l;
        this.m_missed = l2;
    }

    public void writeGoogleProfile(OutputStream outputStream) throws IOException {
        int n = 1;
        HashMap<StackTraceElement, Integer> hashMap = new HashMap<StackTraceElement, Integer>();
        Word word = new Word(outputStream);
        word.putString(String.format("--- symbol\nbinary=%s\n", CpuProfile.mainClassName()));
        for (Map.Entry<List<StackTraceElement>, Long> entry : this.m_counts.entrySet()) {
            for (StackTraceElement stackTraceElement : entry.getKey()) {
                if (hashMap.containsKey(stackTraceElement)) continue;
                word.putString(String.format("0x%016x %s\n", n, stackTraceElement.toString()));
                hashMap.put(stackTraceElement, n);
                ++n;
            }
        }
        word.putString("---\n--- profile\n");
        for (Object object : (Iterator<Map.Entry<List<StackTraceElement>, Long>>)new int[]{0, 3, 0, 1, 0}) {
            word.putWord((long)object);
        }
        for (Map.Entry<List<StackTraceElement>, Long> entry : this.m_counts.entrySet()) {
            List<StackTraceElement> list = entry.getKey();
            long l = entry.getValue();
            if (!list.isEmpty()) {
                word.putWord(l);
                word.putWord(list.size());
            }
            for (StackTraceElement stackTraceElement : list) {
                word.putWord(((Integer)hashMap.get(stackTraceElement)).longValue());
            }
        }
        word.putWord(0L);
        word.putWord(1L);
        word.putWord(0L);
        word.flush();
    }

    protected static boolean isRunnable(StackTraceElement stackTraceElement) {
        return !idleClassAndMethod.contains(new StringPair(stackTraceElement.getClassName(), stackTraceElement.getMethodName()));
    }

    public static CpuProfile record(Duration duration, int n, Thread.State state) {
        if (n > 1000) {
            throw new RuntimeException("frequency must be < 1000");
        }
        HashMap<List<StackTraceElement>, Long> hashMap = new HashMap<List<StackTraceElement>, Long>();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Instant instant = Instant.now();
        Instant instant2 = instant.plus(duration);
        int n2 = 1000 / n;
        long l = Thread.currentThread().getId();
        Instant instant3 = Instant.now();
        long l2 = 0L;
        long l3 = 0L;
        while (Instant.now().isBefore(instant2)) {
            for (ThreadInfo threadInfo : threadMXBean.dumpAllThreads(false, false)) {
                boolean bl;
                List<StackTraceElement> list;
                if (threadInfo.getThreadState() != state || threadInfo.getThreadId() == l || (list = Arrays.asList(threadInfo.getStackTrace())).isEmpty()) continue;
                boolean bl2 = bl = state != Thread.State.RUNNABLE || CpuProfile.isRunnable(list.get(0));
                if (!bl) continue;
                Long l4 = (Long)hashMap.get(list);
                if (l4 == null) {
                    hashMap.put(list, 1L);
                    continue;
                }
                hashMap.put(list, l4 + 1L);
            }
            ++l2;
            instant3 = instant3.plusMillis(n2);
            while (instant3.isBefore(Instant.now()) && instant3.isBefore(instant2)) {
                ++l3;
                instant3 = instant3.plusMillis(n2);
            }
            long l5 = Math.max(instant3.toEpochMilli() - Instant.now().toEpochMilli(), 0L);
            try {
                Thread.sleep(l5);
            }
            catch (InterruptedException interruptedException) {
                System.out.print("CpuProfile interrupted.");
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return new CpuProfile(hashMap, Duration.between(instant, Instant.now()), l2, l3);
    }

    public CpuProfile record(Duration duration, int n) {
        return CpuProfile.record(duration, n, Thread.State.RUNNABLE);
    }

    public static Future<CpuProfile> recordInThread(Duration duration, int n, Thread.State state) {
        FutureTask<CpuProfile> futureTask = new FutureTask<CpuProfile>(() -> CpuProfile.record(duration, n, state));
        Thread thread2 = new Thread(futureTask, "CpuProfile");
        thread2.start();
        return futureTask;
    }

    public static Future<CpuProfile> recordInThread(Duration duration, int n) {
        return CpuProfile.recordInThread(duration, n, Thread.State.RUNNABLE);
    }

    public static String mainClassName() {
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            Thread thread2 = entry.getKey();
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            if (!"main".equals(thread2.getName())) continue;
            for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                if (stackTraceElement.getClassName().startsWith("scala.tools.nsc.MainGenericRunner")) continue;
                return stackTraceElement.getClassName();
            }
        }
        return "unknown";
    }

    static {
        idleClassAndMethod.add(new StringPair("sun.nio.ch.EPollArrayWrapper", "epollWait"));
        idleClassAndMethod.add(new StringPair("sun.nio.ch.KQueueArrayWrapper", "kevent0"));
        idleClassAndMethod.add(new StringPair("java.net.SocketInputStream", "socketRead0"));
        idleClassAndMethod.add(new StringPair("java.net.SocketOutputStream", "socketWrite0"));
        idleClassAndMethod.add(new StringPair("java.net.PlainSocketImpl", "socketAvailable"));
        idleClassAndMethod.add(new StringPair("java.net.PlainSocketImpl", "socketAccept"));
        idleClassAndMethod.add(new StringPair("sun.nio.ch.ServerSocketChannelImpl", "accept0"));
    }

    static class StringPair {
        final String m_a;
        final String m_b;

        StringPair(String string, String string2) {
            this.m_a = string;
            this.m_b = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StringPair stringPair = (StringPair)object;
            return Objects.equals(this.m_a, stringPair.m_a) && Objects.equals(this.m_b, stringPair.m_b);
        }

        public int hashCode() {
            return Objects.hash(this.m_a, this.m_b);
        }
    }

    private static class Word {
        final ByteBuffer m_buf;
        final OutputStream m_os;

        public Word(OutputStream outputStream) {
            this(Word.createBuffer(), outputStream);
        }

        private Word(ByteBuffer byteBuffer, OutputStream outputStream) {
            this.m_buf = byteBuffer;
            this.m_os = outputStream;
        }

        public void putWord(long l) throws IOException {
            this.m_buf.clear();
            this.m_buf.putLong(l);
            this.m_os.write(this.m_buf.array());
        }

        public void putString(String string) throws IOException {
            this.m_os.write(string.getBytes());
        }

        private static ByteBuffer createBuffer() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return byteBuffer;
        }

        public void flush() throws IOException {
            this.m_os.flush();
        }
    }
}

