/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_legal_default_speeds.tagfilter;

import de.westnordost.osm_legal_default_speeds.tagfilter.AllOf;
import de.westnordost.osm_legal_default_speeds.tagfilter.AnyOf;
import de.westnordost.osm_legal_default_speeds.tagfilter.BooleanExpression;
import de.westnordost.osm_legal_default_speeds.tagfilter.BooleanExpressionBuilderKt;
import de.westnordost.osm_legal_default_speeds.tagfilter.BracketHelper;
import de.westnordost.osm_legal_default_speeds.tagfilter.Chain;
import de.westnordost.osm_legal_default_speeds.tagfilter.Leaf;
import de.westnordost.osm_legal_default_speeds.tagfilter.Matcher;
import de.westnordost.osm_legal_default_speeds.tagfilter.Not;
import de.westnordost.osm_legal_default_speeds.tagfilter.NotPlaceholder;
import de.westnordost.osm_legal_default_speeds.tagfilter.Placeholder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0013\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/westnordost/osm_legal_default_speeds/tagfilter/BooleanExpressionBuilder;", "I", "Lde/westnordost/osm_legal_default_speeds/tagfilter/Matcher;", "T", "", "()V", "bracketCount", "", "node", "Lde/westnordost/osm_legal_default_speeds/tagfilter/Chain;", "addAnd", "", "addCloseBracket", "addNot", "addNotPlaceholder", "p", "", "addOpenBracket", "addOr", "addPlaceholder", "addValue", "i", "(Lde/westnordost/osm_legal_default_speeds/tagfilter/Matcher;)V", "build", "Lde/westnordost/osm_legal_default_speeds/tagfilter/BooleanExpression;", "library"})
public final class BooleanExpressionBuilder<I extends Matcher<? super T>, T> {
    @NotNull
    private Chain<I, T> node = new BracketHelper();
    private int bracketCount;

    @Nullable
    public final BooleanExpression<I, T> build() {
        if (this.bracketCount > 0) {
            throw new IllegalStateException("Closed one bracket too little");
        }
        while (this.node.getParent() != null) {
            Intrinsics.checkNotNull(this.node.getParent());
            this.node = this.node;
        }
        this.node.flatten();
        switch (this.node.getChildren().size()) {
            case 0: {
                return null;
            }
            case 1: {
                BooleanExpression<I, T> firstChild = CollectionsKt.first(this.node.getChildren());
                this.node.removeChild(firstChild);
                return firstChild;
            }
        }
        BooleanExpressionBuilderKt.access$ensureNoBracketNodes(this.node);
        return this.node;
    }

    public final void addOpenBracket() {
        BracketHelper group = new BracketHelper();
        this.node.addChild(group);
        this.node = group;
        int n = this.bracketCount;
        this.bracketCount = n + 1;
    }

    public final void addCloseBracket() {
        this.bracketCount += -1;
        if (this.bracketCount < 0) {
            throw new IllegalStateException("Closed one bracket too much");
        }
        while (!(this.node instanceof BracketHelper)) {
            Intrinsics.checkNotNull(this.node.getParent());
            this.node = this.node;
        }
        Chain chain = this.node.getParent();
        Intrinsics.checkNotNull(chain);
        this.node = chain;
        if (this.node instanceof Not) {
            Chain chain2 = this.node.getParent();
            Intrinsics.checkNotNull(chain2);
            this.node = chain2;
        }
    }

    public final void addValue(@NotNull I i) {
        Intrinsics.checkNotNullParameter(i, "i");
        this.node.addChild(new Leaf(i));
    }

    public final void addPlaceholder(@NotNull String p) {
        Intrinsics.checkNotNullParameter(p, "p");
        this.node.addChild(new Placeholder(p));
    }

    public final void addNotPlaceholder(@NotNull String p) {
        Intrinsics.checkNotNullParameter(p, "p");
        this.node.addChild(new NotPlaceholder(p));
    }

    public final void addAnd() {
        if (!(this.node instanceof AllOf)) {
            BooleanExpression<I, T> last = CollectionsKt.last(this.node.getChildren());
            AllOf<I, T> allOf = new AllOf<I, T>();
            this.node.replaceChild(last, allOf);
            allOf.addChild(last);
            this.node = allOf;
        }
    }

    public final void addOr() {
        BracketHelper group;
        Chain<I, T> chain = this.node;
        AllOf allOf = chain instanceof AllOf ? (AllOf)chain : null;
        Chain<I, T> chain2 = this.node;
        BracketHelper bracketHelper = group = chain2 instanceof BracketHelper ? (BracketHelper)chain2 : null;
        if (allOf != null) {
            Chain nodeParent = this.node.getParent();
            if (nodeParent instanceof AnyOf) {
                this.node = nodeParent;
            } else {
                Chain chain3 = nodeParent;
                if (chain3 != null) {
                    chain3.removeChild(allOf);
                }
                AnyOf anyOf = new AnyOf();
                anyOf.addChild(allOf);
                Chain chain4 = nodeParent;
                if (chain4 != null) {
                    chain4.addChild(anyOf);
                }
                this.node = anyOf;
            }
        } else if (group != null) {
            BooleanExpression<I, T> last = CollectionsKt.last(this.node.getChildren());
            AnyOf<I, T> anyOf = new AnyOf<I, T>();
            this.node.replaceChild(last, anyOf);
            anyOf.addChild(last);
            this.node = anyOf;
        }
    }

    public final void addNot() {
        Not not = new Not();
        this.node.addChild(not);
        this.node = not;
    }
}

