/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.codahale.metrics.health.HealthCheckRegistry;
import io.dropwizard.health.HealthCheckConfiguration;
import io.dropwizard.lifecycle.Managed;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HealthCheckConfigValidator
implements Managed {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckConfigValidator.class);
    private final List<HealthCheckConfiguration> configs;
    private final HealthCheckRegistry registry;

    public HealthCheckConfigValidator(List<HealthCheckConfiguration> configs, HealthCheckRegistry registry) {
        this.configs = configs;
        this.registry = registry;
    }

    @Override
    public void start() throws Exception {
        this.validateConfiguration(this.configs, this.registry.getNames());
    }

    private void validateConfiguration(List<HealthCheckConfiguration> healthCheckConfigs, Set<String> registeredHealthCheckNames) {
        List notRegisteredHealthCheckNames;
        Set configuredHealthCheckNames = healthCheckConfigs.stream().map(HealthCheckConfiguration::getName).collect(Collectors.toSet());
        List notConfiguredHealthCheckNames = registeredHealthCheckNames.stream().filter(healthCheckName -> !configuredHealthCheckNames.contains(healthCheckName)).sorted().collect(Collectors.toList());
        if (!notConfiguredHealthCheckNames.isEmpty()) {
            String healthCheckList = notConfiguredHealthCheckNames.stream().map(name -> "  * " + name).collect(Collectors.joining("\n"));
            LOGGER.info("The following health check(s) were registered, but are not configured with a schedule:\n{}", (Object)healthCheckList);
        }
        if (!(notRegisteredHealthCheckNames = configuredHealthCheckNames.stream().filter(healthCheckName -> !registeredHealthCheckNames.contains(healthCheckName)).sorted().collect(Collectors.toList())).isEmpty()) {
            String healthCheckList = notRegisteredHealthCheckNames.stream().map(name -> "  * " + name).collect(Collectors.joining("\n"));
            LOGGER.error("The following health check(s) are configured with a schedule, but were not registered:\n{}", (Object)healthCheckList);
            throw new IllegalStateException("The following configured health checks were not registered: " + String.valueOf(notRegisteredHealthCheckNames));
        }
    }
}

