/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.codahale.metrics.Counter;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.health.HealthCheckType;
import io.dropwizard.health.HealthStateView;
import io.dropwizard.health.Schedule;
import io.dropwizard.health.State;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduledHealthCheck
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledHealthCheck.class);
    private final String name;
    private final HealthCheckType type;
    private final boolean critical;
    private final HealthCheck healthCheck;
    private final Schedule schedule;
    private final State state;
    private final Counter healthyCheckCounter;
    private final Counter unhealthyCheckCounter;
    private boolean previouslyRecovered = false;

    ScheduledHealthCheck(String name, HealthCheckType type, boolean critical, HealthCheck healthCheck, Schedule schedule, State state, Counter healthyCheckCounter, Counter unhealthyCheckCounter) {
        this.name = Objects.requireNonNull(name);
        this.type = type;
        this.critical = critical;
        this.healthCheck = Objects.requireNonNull(healthCheck);
        this.schedule = Objects.requireNonNull(schedule);
        this.state = Objects.requireNonNull(state);
        this.healthyCheckCounter = Objects.requireNonNull(healthyCheckCounter);
        this.unhealthyCheckCounter = Objects.requireNonNull(unhealthyCheckCounter);
    }

    public String getName() {
        return this.name;
    }

    public HealthCheckType getType() {
        return this.type;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean isHealthy() {
        return this.state.getHealthy().get();
    }

    public boolean isPreviouslyRecovered() {
        return this.previouslyRecovered;
    }

    @Override
    public void run() {
        HealthCheck.Result result;
        LOGGER.trace("executing health check: name={}", (Object)this.name);
        boolean previousState = this.state.getHealthy().get();
        try {
            result = this.healthCheck.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Check for name={} failed exceptionally", (Object)this.name, (Object)e);
            result = HealthCheck.Result.unhealthy(e);
        }
        if (result.isHealthy()) {
            LOGGER.trace("health check result: name={} result=success", (Object)this.name);
            this.state.success();
            this.healthyCheckCounter.inc();
            if (!this.previouslyRecovered && !previousState) {
                this.previouslyRecovered = true;
            }
        } else {
            LOGGER.trace("health check result: name={} result=failure result={}", (Object)this.name, (Object)result);
            this.state.failure();
            this.unhealthyCheckCounter.inc();
        }
    }

    public HealthStateView view() {
        return new HealthStateView(this.name, this.isHealthy(), this.type, this.isCritical());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledHealthCheck)) {
            return false;
        }
        ScheduledHealthCheck that = (ScheduledHealthCheck)o;
        return this.critical == that.critical && this.previouslyRecovered == that.previouslyRecovered && Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.healthCheck, that.healthCheck) && Objects.equals(this.schedule, that.schedule) && Objects.equals(this.state, that.state) && Objects.equals(this.healthyCheckCounter, that.healthyCheckCounter) && Objects.equals(this.unhealthyCheckCounter, that.unhealthyCheckCounter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.critical, this.healthCheck, this.schedule, this.state, this.healthyCheckCounter, this.unhealthyCheckCounter, this.previouslyRecovered});
    }

    public String toString() {
        return "ScheduledHealthCheck{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + ", critical=" + this.critical + ", healthCheck=" + String.valueOf(this.healthCheck) + ", schedule=" + String.valueOf(this.schedule) + ", state=" + String.valueOf(this.state) + ", healthyCheckCounter=" + String.valueOf(this.healthyCheckCounter) + ", unhealthyCheckCounter=" + String.valueOf(this.unhealthyCheckCounter) + ", previouslyRecovered=" + this.previouslyRecovered + "}";
    }

    private String getCounterString(Counter counter) {
        return Counter.class.equals(counter.getClass()) ? String.valueOf(counter.getCount()) : counter.toString();
    }
}

