/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.setup;

import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.setup.JerseyContainerHolder;
import jakarta.servlet.Servlet;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyEnvironment {
    private final JerseyContainerHolder holder;
    private final DropwizardResourceConfig config;

    public JerseyEnvironment(JerseyContainerHolder holder, DropwizardResourceConfig config) {
        this.holder = holder;
        this.config = config;
    }

    public void disable() {
        this.holder.setContainer(null);
    }

    public void replace(Function<ResourceConfig, Servlet> replace) {
        this.holder.setContainer(replace.apply(this.config));
    }

    public void register(Object component) {
        this.config.register(Objects.requireNonNull(component));
    }

    public void register(Class<?> componentClass) {
        this.config.register((Class)Objects.requireNonNull(componentClass));
    }

    public void packages(String ... packages) {
        this.config.packages(Objects.requireNonNull(packages));
    }

    public void enable(String featureName) {
        this.config.property(Objects.requireNonNull(featureName), Boolean.TRUE);
    }

    public void disable(String featureName) {
        this.config.property(Objects.requireNonNull(featureName), Boolean.FALSE);
    }

    public void property(String name, @Nullable Object value) {
        this.config.property(Objects.requireNonNull(name), value);
    }

    public <T> @Nullable T getProperty(String name) {
        return (T)this.config.getProperties().get(name);
    }

    public String getUrlPattern() {
        return this.config.getUrlPattern();
    }

    public void setUrlPattern(String urlPattern) {
        Object normalizedUrlPattern = urlPattern;
        if (!((String)normalizedUrlPattern).endsWith("*") && !((String)normalizedUrlPattern).endsWith("/")) {
            normalizedUrlPattern = (String)normalizedUrlPattern + "/";
        }
        if (!((String)normalizedUrlPattern).endsWith("*")) {
            normalizedUrlPattern = (String)normalizedUrlPattern + "*";
        }
        this.config.setUrlPattern((String)normalizedUrlPattern);
    }

    public DropwizardResourceConfig getResourceConfig() {
        return this.config;
    }
}

