/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import io.dropwizard.jersey.validation.JerseyViolationException;
import io.dropwizard.validation.ConstraintViolations;
import io.dropwizard.validation.Validated;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardConfiguredValidator
implements ConfiguredValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardConfiguredValidator.class);
    private final Validator validator;

    public DropwizardConfiguredValidator(Validator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public void validateResourceAndInputParams(Object resource, Invocable invocable, Object[] objects) throws ConstraintViolationException {
        Class<?>[] groups2 = this.getGroup(invocable);
        HashSet<ConstraintViolation<Object>> violations = new HashSet<ConstraintViolation<Object>>();
        BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
        if (beanDescriptor.isBeanConstrained()) {
            violations.addAll(this.validate(resource, groups2));
        }
        violations.addAll(this.forExecutables().validateParameters(resource, invocable.getHandlingMethod(), objects, groups2));
        if (!violations.isEmpty()) {
            throw new JerseyViolationException(violations, invocable);
        }
    }

    private Class<?>[] getGroup(Invocable invocable) {
        ArrayList<Class<?>[]> groups2 = new ArrayList<Class<?>[]>();
        for (Parameter parameter : invocable.getParameters()) {
            if (!parameter.isAnnotationPresent(Validated.class)) continue;
            groups2.add(parameter.getAnnotation(Validated.class).value());
        }
        switch (groups2.size()) {
            case 0: {
                return new Class[]{Default.class};
            }
            case 1: {
                return (Class[])groups2.get(0);
            }
        }
        for (int i = 0; i < groups2.size(); ++i) {
            for (int j = i; j < groups2.size(); ++j) {
                if (Arrays.deepEquals((Object[])groups2.get(i), (Object[])groups2.get(j))) continue;
                throw new WebApplicationException("Parameters must have the same validation groups in " + invocable.getHandlingMethod().getName(), 500);
            }
        }
        return (Class[])groups2.get(0);
    }

    @Override
    public void validateResult(Object resource, Invocable invocable, Object returnValue) throws ConstraintViolationException {
        Class<Object>[] groups2 = invocable.getHandlingMethod().isAnnotationPresent(Validated.class) ? invocable.getHandlingMethod().getAnnotation(Validated.class).value() : new Class[]{Default.class};
        Set violations = this.forExecutables().validateReturnValue(resource, invocable.getHandlingMethod(), returnValue, groups2);
        if (!violations.isEmpty()) {
            LOGGER.trace("Response validation failed: {}", (Object)ConstraintViolations.copyOf(violations));
            throw new JerseyViolationException(violations, invocable);
        }
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T t2, Class<?> ... classes) {
        return this.validator.validate(t2, classes);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T t2, String s2, Class<?> ... classes) {
        return this.validator.validateProperty(t2, s2, classes);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> aClass, String s2, Object o, Class<?> ... classes) {
        return this.validator.validateValue(aClass, s2, o, classes);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> aClass) {
        return this.validator.getConstraintsForClass(aClass);
    }

    @Override
    public <T> T unwrap(Class<T> aClass) {
        return this.validator.unwrap(aClass);
    }

    @Override
    public ExecutableValidator forExecutables() {
        return this.validator.forExecutables();
    }
}

