/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common.socket;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import io.dropwizard.logging.common.ResilientSocketOutputStream;
import java.io.OutputStream;
import javax.net.SocketFactory;

public class DropwizardSocketAppender<E extends DeferredProcessingAware>
extends OutputStreamAppender<E> {
    private final String host;
    private final int port;
    private final int connectionTimeoutMs;
    private final int sendBufferSize;
    private final SocketFactory socketFactory;

    public DropwizardSocketAppender(String host, int port, int connectionTimeoutMs, int sendBufferSize, SocketFactory socketFactory) {
        this.host = host;
        this.port = port;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.sendBufferSize = sendBufferSize;
        this.socketFactory = socketFactory;
    }

    @Override
    public void start() {
        this.setOutputStream(this.socketOutputStream());
        super.start();
    }

    protected OutputStream socketOutputStream() {
        ResilientSocketOutputStream outputStream = new ResilientSocketOutputStream(this.host, this.port, this.connectionTimeoutMs, this.sendBufferSize, this.socketFactory);
        outputStream.setContext(this.context);
        return outputStream;
    }
}

