/*
 * Decompiled with CFR 0.152.
 */
package no.ecc.vectortile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import no.ecc.vectortile.Filter;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import vector_tile.VectorTile;

public class VectorTileDecoder {
    private boolean autoScale = true;

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public FeatureIterable decode(byte[] data) throws IOException {
        return this.decode(data, Filter.ALL);
    }

    public FeatureIterable decode(byte[] data, String layerName) throws IOException {
        return this.decode(data, new Filter.Single(layerName));
    }

    public FeatureIterable decode(byte[] data, Set<String> layerNames) throws IOException {
        return this.decode(data, new Filter.Any(layerNames));
    }

    public FeatureIterable decode(byte[] data, Filter filter) throws IOException {
        VectorTile.Tile tile = VectorTile.Tile.parseFrom(data);
        return new FeatureIterable(tile, filter, this.autoScale);
    }

    static int zigZagDecode(int n) {
        return n >> 1 ^ -(n & 1);
    }

    /*
     * WARNING - void declaration
     */
    static Geometry decodeGeometry(GeometryFactory gf, VectorTile.Tile.GeomType geomType, List<Integer> commands, double scale) {
        int x = 0;
        int y = 0;
        ArrayList coordsList = new ArrayList();
        ArrayList<Object> coords = null;
        int geometryCount = commands.size();
        int length = 0;
        int command = 0;
        int i = 0;
        while (i < geometryCount) {
            if (length <= 0) {
                length = commands.get(i++);
                command = length & 7;
                length >>= 3;
            }
            if (length <= 0) continue;
            if (command == 1) {
                coords = new ArrayList<Object>();
                coordsList.add(coords);
            }
            if (command == 7) {
                if (geomType != VectorTile.Tile.GeomType.POINT && !coords.isEmpty()) {
                    coords.add(new Coordinate((Coordinate)coords.get(0)));
                }
                --length;
                continue;
            }
            int dx = commands.get(i++);
            int dy = commands.get(i++);
            --length;
            dx = VectorTileDecoder.zigZagDecode(dx);
            dy = VectorTileDecoder.zigZagDecode(dy);
            Coordinate coord = new Coordinate((double)(x += dx) / scale, (double)(y += dy) / scale);
            coords.add(coord);
        }
        Geometry geometry = null;
        switch (geomType) {
            case LINESTRING: {
                ArrayList<LineString> lineStrings = new ArrayList<LineString>();
                for (List list : coordsList) {
                    if (list.size() <= 1) continue;
                    lineStrings.add(gf.createLineString(list.toArray(new Coordinate[list.size()])));
                }
                if (lineStrings.size() == 1) {
                    geometry = (Geometry)lineStrings.get(0);
                    break;
                }
                if (lineStrings.size() <= 1) break;
                geometry = gf.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
                break;
            }
            case POINT: {
                ArrayList allCoords = new ArrayList();
                for (List list : coordsList) {
                    allCoords.addAll(list);
                }
                if (allCoords.size() == 1) {
                    geometry = gf.createPoint((Coordinate)allCoords.get(0));
                    break;
                }
                if (allCoords.size() <= 1) break;
                geometry = gf.createMultiPointFromCoords(allCoords.toArray(new Coordinate[allCoords.size()]));
                break;
            }
            case POLYGON: {
                void var17_22;
                ArrayList<void> arrayList = new ArrayList<void>();
                Object var17_21 = null;
                Boolean ccw = null;
                for (List list : coordsList) {
                    boolean thisCcw;
                    Coordinate[] coordinateArray = list.toArray(new Coordinate[list.size()]);
                    double area = Area.ofRingSigned(coordinateArray);
                    if (area == 0.0) continue;
                    boolean bl = thisCcw = area < 0.0;
                    if (ccw == null) {
                        ccw = thisCcw;
                    }
                    LinearRing ring = gf.createLinearRing(coordinateArray);
                    if (ccw == thisCcw) {
                        if (var17_22 != null) {
                            arrayList.add(var17_22);
                        }
                        ArrayList arrayList2 = new ArrayList();
                    }
                    var17_22.add(ring);
                }
                if (var17_22 != null) {
                    arrayList.add(var17_22);
                }
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                for (List list : arrayList) {
                    LinearRing shell = (LinearRing)list.get(0);
                    LinearRing[] holes = list.subList(1, list.size()).toArray(new LinearRing[list.size() - 1]);
                    polygons.add(gf.createPolygon(shell, holes));
                }
                if (polygons.size() == 1) {
                    geometry = (Geometry)polygons.get(0);
                }
                if (polygons.size() <= 1) break;
                geometry = gf.createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        if (geometry == null) {
            geometry = gf.createGeometryCollection(new Geometry[0]);
        }
        return geometry;
    }

    public static final class FeatureIterable
    implements Iterable<Feature> {
        private final VectorTile.Tile tile;
        private final Filter filter;
        private boolean autoScale;

        public FeatureIterable(VectorTile.Tile tile, Filter filter, boolean autoScale) {
            this.tile = tile;
            this.filter = filter;
            this.autoScale = autoScale;
        }

        @Override
        public Iterator<Feature> iterator() {
            return new FeatureIterator(this.tile, this.filter, this.autoScale);
        }

        public List<Feature> asList() {
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Feature feature : this) {
                features.add(feature);
            }
            return features;
        }

        public Collection<String> getLayerNames() {
            HashSet<String> layerNames = new HashSet<String>();
            for (VectorTile.Tile.Layer layer : this.tile.getLayersList()) {
                layerNames.add(layer.getName());
            }
            return Collections.unmodifiableSet(layerNames);
        }
    }

    public static final class Feature {
        private final String layerName;
        private final int extent;
        private final long id;
        private final Geometry geometry;
        private final Map<String, Object> attributes;

        public Feature(String layerName, int extent, Geometry geometry, Map<String, Object> attributes, long id) {
            this.layerName = layerName;
            this.extent = extent;
            this.geometry = geometry;
            this.attributes = attributes;
            this.id = id;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public long getId() {
            return this.id;
        }

        public int getExtent() {
            return this.extent;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }

    private static final class FeatureIterator
    implements Iterator<Feature> {
        private final GeometryFactory gf = new GeometryFactory();
        private final Filter filter;
        private final Iterator<VectorTile.Tile.Layer> layerIterator;
        private Iterator<VectorTile.Tile.Feature> featureIterator;
        private int extent;
        private String layerName;
        private double scale;
        private boolean autoScale;
        private final List<String> keys = new ArrayList<String>();
        private final List<Object> values = new ArrayList<Object>();
        private Feature next;

        public FeatureIterator(VectorTile.Tile tile, Filter filter, boolean autoScale) {
            this.layerIterator = tile.getLayersList().iterator();
            this.filter = filter;
            this.autoScale = autoScale;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public Feature next() {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Feature n = this.next;
            this.next = null;
            return n;
        }

        private void findNext() {
            block3: {
                if (this.next != null) {
                    return;
                }
                while (this.featureIterator == null || !this.featureIterator.hasNext()) {
                    if (!this.layerIterator.hasNext()) {
                        this.next = null;
                        break block3;
                    }
                    VectorTile.Tile.Layer layer = this.layerIterator.next();
                    if (!this.filter.include(layer.getName())) continue;
                    this.parseLayer(layer);
                }
                this.next = this.parseFeature(this.featureIterator.next());
            }
        }

        private void parseLayer(VectorTile.Tile.Layer layer) {
            this.layerName = layer.getName();
            this.extent = layer.getExtent();
            this.scale = this.autoScale ? (double)this.extent / 256.0 : 1.0;
            this.keys.clear();
            this.keys.addAll(layer.getKeysList());
            this.values.clear();
            for (VectorTile.Tile.Value value : layer.getValuesList()) {
                if (value.hasBoolValue()) {
                    this.values.add(value.getBoolValue());
                    continue;
                }
                if (value.hasDoubleValue()) {
                    this.values.add(value.getDoubleValue());
                    continue;
                }
                if (value.hasFloatValue()) {
                    this.values.add(Float.valueOf(value.getFloatValue()));
                    continue;
                }
                if (value.hasIntValue()) {
                    this.values.add(value.getIntValue());
                    continue;
                }
                if (value.hasSintValue()) {
                    this.values.add(value.getSintValue());
                    continue;
                }
                if (value.hasUintValue()) {
                    this.values.add(value.getUintValue());
                    continue;
                }
                if (value.hasStringValue()) {
                    this.values.add(value.getStringValue());
                    continue;
                }
                this.values.add(null);
            }
            this.featureIterator = layer.getFeaturesList().iterator();
        }

        private Feature parseFeature(VectorTile.Tile.Feature feature) {
            int tagsCount = feature.getTagsCount();
            HashMap<String, Object> attributes = new HashMap<String, Object>(tagsCount / 2);
            int tagIdx = 0;
            while (tagIdx < feature.getTagsCount()) {
                String key = this.keys.get(feature.getTags(tagIdx++));
                Object value = this.values.get(feature.getTags(tagIdx++));
                attributes.put(key, value);
            }
            Geometry geometry = VectorTileDecoder.decodeGeometry(this.gf, feature.getType(), feature.getGeometryList(), this.scale);
            if (geometry == null) {
                geometry = this.gf.createGeometryCollection(new Geometry[0]);
            }
            return new Feature(this.layerName, this.extent, geometry, Collections.unmodifiableMap(attributes), feature.getId());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

