/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.RuntimeDelegateDecorator;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.LanguageTag;
import org.glassfish.jersey.message.internal.LinkProvider;

public abstract class MessageHeaderMethods {
    protected RuntimeDelegate runtimeDelegateDecorator;

    protected MessageHeaderMethods(Configuration configuration) {
        this.runtimeDelegateDecorator = RuntimeDelegateDecorator.configured(configuration);
    }

    protected MessageHeaderMethods(MessageHeaderMethods other) {
        this.runtimeDelegateDecorator = other.runtimeDelegateDecorator;
    }

    public abstract String getHeaderString(String var1);

    public abstract MultivaluedMap<String, ?> getHeaders();

    protected abstract HeaderValueException.Context getHeaderValueExceptionContext();

    public abstract Set<Link> getLinks();

    public boolean containsHeaderString(String name, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        String[] split;
        String header = this.getHeaderString(name);
        if (header == null) {
            return false;
        }
        for (String s2 : split = header.split(valueSeparatorRegex)) {
            if (!valuePredicate.test(s2.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean containsHeaderString(String name, Predicate<String> valuePredicate) {
        return this.containsHeaderString(name, ",", valuePredicate);
    }

    public Set<String> getAllowedMethods() {
        String allowed = this.getHeaderString("Allow");
        if (allowed == null || allowed.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            return new HashSet<String>(HttpHeaderReader.readStringList(allowed.toUpperCase(Locale.ROOT)));
        }
        catch (ParseException e) {
            throw this.exception("Allow", allowed, e);
        }
    }

    public Date getDate() {
        return this.singleHeader("Date", Date.class, input -> {
            try {
                return HttpHeaderReader.readDate(input);
            }
            catch (ParseException e) {
                throw new ProcessingException(e);
            }
        }, false);
    }

    public EntityTag getEntityTag() {
        return this.singleHeader("ETag", EntityTag.class, new Function<String, EntityTag>(){

            @Override
            public EntityTag apply(String value) {
                try {
                    return value == null ? null : EntityTag.valueOf(value);
                }
                catch (IllegalArgumentException ex) {
                    throw new ProcessingException(ex);
                }
            }
        }, false);
    }

    public Locale getLanguage() {
        return this.singleHeader("Content-Language", Locale.class, input -> {
            try {
                return new LanguageTag((String)input).getAsLocale();
            }
            catch (ParseException e) {
                throw new ProcessingException(e);
            }
        }, false);
    }

    public Date getLastModified() {
        return this.singleHeader("Last-Modified", Date.class, new Function<String, Date>(){

            @Override
            public Date apply(String input) {
                try {
                    return HttpHeaderReader.readDate(input);
                }
                catch (ParseException e) {
                    throw new ProcessingException(e);
                }
            }
        }, false);
    }

    public int getLength() {
        return this.singleHeader("Content-Length", Integer.class, input -> {
            try {
                int i;
                if (input != null && !input.isEmpty() && (i = Integer.parseInt(input)) >= 0) {
                    return i;
                }
                return -1;
            }
            catch (NumberFormatException ex) {
                throw new ProcessingException(ex);
            }
        }, true);
    }

    public long getLengthLong() {
        return this.singleHeader("Content-Length", Long.class, input -> {
            try {
                long l;
                if (input != null && !input.isEmpty() && (l = Long.parseLong(input)) >= 0L) {
                    return l;
                }
                return -1L;
            }
            catch (NumberFormatException ex) {
                throw new ProcessingException(ex);
            }
        }, true);
    }

    public Link getLink(String relation) {
        for (Link link : this.getLinks()) {
            List<String> relations = LinkProvider.getLinkRelations(link.getRel());
            if (relations == null || !relations.contains(relation)) continue;
            return link;
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink(link);
    }

    public URI getLocation() {
        return this.singleHeader("Location", URI.class, value -> {
            try {
                return value == null ? null : URI.create(value);
            }
            catch (IllegalArgumentException ex) {
                throw new ProcessingException(ex);
            }
        }, false);
    }

    public Map<String, Cookie> getRequestCookies() {
        List cookies = (List)this.getHeaders().get("Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> result = new HashMap<String, Cookie>();
        for (String cookie : this.toStringList(cookies)) {
            if (cookie == null) continue;
            result.putAll(HttpHeaderReader.readCookies(cookie));
        }
        return result;
    }

    public Map<String, NewCookie> getResponseCookies() {
        List cookies = (List)this.getHeaders().get("Set-Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> result = new HashMap<String, NewCookie>();
        for (String cookie : this.toStringList(cookies)) {
            if (cookie == null) continue;
            NewCookie newCookie = HttpHeaderReader.readNewCookie(cookie);
            String cookieName = newCookie.getName();
            if (result.containsKey(cookieName)) {
                result.put(cookieName, HeaderUtils.getPreferredCookie((NewCookie)result.get(cookieName), newCookie));
                continue;
            }
            result.put(cookieName, newCookie);
        }
        return result;
    }

    public boolean hasLink(String relation) {
        for (Link link : this.getLinks()) {
            List<String> relations = LinkProvider.getLinkRelations(link.getRel());
            if (relations == null || !relations.contains(relation)) continue;
            return true;
        }
        return false;
    }

    protected <T> T singleHeader(String name, Class<T> valueType, Function<String, T> converter, boolean convertNull) {
        List values2 = (List)this.getHeaders().get(name);
        if (values2 == null || values2.isEmpty()) {
            return convertNull ? (T)converter.apply(null) : null;
        }
        if (values2.size() > 1) {
            throw new HeaderValueException(LocalizationMessages.TOO_MANY_HEADER_VALUES(name, values2.toString()), this.getHeaderValueExceptionContext());
        }
        Object value = values2.get(0);
        if (value == null) {
            return convertNull ? (T)converter.apply(null) : null;
        }
        if (HeaderValueException.Context.OUTBOUND == this.getHeaderValueExceptionContext() && valueType.isInstance(value)) {
            return valueType.cast(value);
        }
        try {
            return converter.apply(HeaderUtils.asString(value, this.runtimeDelegateDecorator));
        }
        catch (ProcessingException ex) {
            throw this.exception(name, value, ex);
        }
    }

    protected <T> T singleHeader(String name, Function<String, T> converter, boolean convertNull) {
        return this.singleHeader(name, null, converter, convertNull);
    }

    protected HeaderValueException exception(String headerName, Object headerValue, Exception e) {
        return new HeaderValueException(LocalizationMessages.UNABLE_TO_PARSE_HEADER_VALUE(headerName, headerValue), e, this.getHeaderValueExceptionContext());
    }

    private List<String> toStringList(List list) {
        return this.getHeaderValueExceptionContext() == HeaderValueException.Context.OUTBOUND ? HeaderUtils.asStringList((List<Object>)list, this.runtimeDelegateDecorator) : list;
    }
}

