/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.glassfish.jersey.server.validation.ValidationErrorData;

public final class ValidationHelper {
    public static List<ValidationErrorData> constraintViolationToValidationErrors(ConstraintViolationException violation) {
        return violation.getConstraintViolations().stream().map(violation1 -> ValidationErrorData.createValidationError(violation1.getMessage(), violation1.getMessageTemplate(), ValidationHelper.getViolationPath(violation1), ValidationHelper.getViolationInvalidValue(violation1.getInvalidValue()))).collect(Collectors.toList());
    }

    private static String getViolationInvalidValue(Object invalidValue) {
        if (invalidValue == null) {
            return null;
        }
        if (invalidValue.getClass().isArray()) {
            if (invalidValue instanceof Object[]) {
                return Arrays.toString((Object[])invalidValue);
            }
            if (invalidValue instanceof boolean[]) {
                return Arrays.toString((boolean[])invalidValue);
            }
            if (invalidValue instanceof byte[]) {
                return Arrays.toString((byte[])invalidValue);
            }
            if (invalidValue instanceof char[]) {
                return Arrays.toString((char[])invalidValue);
            }
            if (invalidValue instanceof double[]) {
                return Arrays.toString((double[])invalidValue);
            }
            if (invalidValue instanceof float[]) {
                return Arrays.toString((float[])invalidValue);
            }
            if (invalidValue instanceof int[]) {
                return Arrays.toString((int[])invalidValue);
            }
            if (invalidValue instanceof long[]) {
                return Arrays.toString((long[])invalidValue);
            }
            if (invalidValue instanceof short[]) {
                return Arrays.toString((short[])invalidValue);
            }
        }
        return invalidValue.toString();
    }

    private static String getViolationPath(ConstraintViolation violation) {
        String rootBeanName = violation.getRootBean().getClass().getSimpleName();
        String propertyPath = violation.getPropertyPath().toString();
        return rootBeanName + (!"".equals(propertyPath) ? '.' + propertyPath : "");
    }

    public static Response.Status getResponseStatus(ConstraintViolationException violation) {
        Iterator<ConstraintViolation<?>> iterator2 = violation.getConstraintViolations().iterator();
        if (iterator2.hasNext()) {
            for (Path.Node node : iterator2.next().getPropertyPath()) {
                ElementKind kind = node.getKind();
                if (!ElementKind.RETURN_VALUE.equals((Object)kind)) continue;
                return Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    private ValidationHelper() {
    }
}

