/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.hprtree;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.hprtree.HilbertEncoder;
import org.locationtech.jts.index.hprtree.Item;
import org.locationtech.jts.util.IntArrayList;

public class HPRtree
implements SpatialIndex {
    private static final int ENV_SIZE = 4;
    private static final int HILBERT_LEVEL = 12;
    private static final int DEFAULT_NODE_CAPACITY = 16;
    private List<Item> itemsToLoad = new ArrayList<Item>();
    private final int nodeCapacity;
    private int numItems = 0;
    private final Envelope totalExtent = new Envelope();
    private int[] layerStartIndex;
    private double[] nodeBounds;
    private double[] itemBounds;
    private Object[] itemValues;
    private volatile boolean isBuilt = false;

    public HPRtree() {
        this(16);
    }

    public HPRtree(int nodeCapacity) {
        this.nodeCapacity = nodeCapacity;
    }

    public int size() {
        return this.numItems;
    }

    @Override
    public void insert(Envelope itemEnv, Object item) {
        if (this.isBuilt) {
            throw new IllegalStateException("Cannot insert items after tree is built.");
        }
        ++this.numItems;
        this.itemsToLoad.add(new Item(itemEnv, item));
        this.totalExtent.expandToInclude(itemEnv);
    }

    @Override
    public List query(Envelope searchEnv) {
        this.build();
        if (!this.totalExtent.intersects(searchEnv)) {
            return new ArrayList();
        }
        ArrayListVisitor visitor = new ArrayListVisitor();
        this.query(searchEnv, visitor);
        return visitor.getItems();
    }

    @Override
    public void query(Envelope searchEnv, ItemVisitor visitor) {
        this.build();
        if (!this.totalExtent.intersects(searchEnv)) {
            return;
        }
        if (this.layerStartIndex == null) {
            this.queryItems(0, searchEnv, visitor);
        } else {
            this.queryTopLayer(searchEnv, visitor);
        }
    }

    private void queryTopLayer(Envelope searchEnv, ItemVisitor visitor) {
        int layerIndex = this.layerStartIndex.length - 2;
        int layerSize = this.layerSize(layerIndex);
        for (int i = 0; i < layerSize; i += 4) {
            this.queryNode(layerIndex, i, searchEnv, visitor);
        }
    }

    private void queryNode(int layerIndex, int nodeOffset, Envelope searchEnv, ItemVisitor visitor) {
        int layerStart = this.layerStartIndex[layerIndex];
        int nodeIndex = layerStart + nodeOffset;
        if (!HPRtree.intersects(this.nodeBounds, nodeIndex, searchEnv)) {
            return;
        }
        if (layerIndex == 0) {
            int childNodesOffset = nodeOffset / 4 * this.nodeCapacity;
            this.queryItems(childNodesOffset, searchEnv, visitor);
        } else {
            int childNodesOffset = nodeOffset * this.nodeCapacity;
            this.queryNodeChildren(layerIndex - 1, childNodesOffset, searchEnv, visitor);
        }
    }

    private static boolean intersects(double[] bounds, int nodeIndex, Envelope env) {
        boolean isBeyond = env.getMaxX() < bounds[nodeIndex] || env.getMaxY() < bounds[nodeIndex + 1] || env.getMinX() > bounds[nodeIndex + 2] || env.getMinY() > bounds[nodeIndex + 3];
        return !isBeyond;
    }

    private void queryNodeChildren(int layerIndex, int blockOffset, Envelope searchEnv, ItemVisitor visitor) {
        int nodeOffset;
        int layerStart = this.layerStartIndex[layerIndex];
        int layerEnd = this.layerStartIndex[layerIndex + 1];
        for (int i = 0; i < this.nodeCapacity && layerStart + (nodeOffset = blockOffset + 4 * i) < layerEnd; ++i) {
            this.queryNode(layerIndex, nodeOffset, searchEnv, visitor);
        }
    }

    private void queryItems(int blockStart, Envelope searchEnv, ItemVisitor visitor) {
        int itemIndex;
        for (int i = 0; i < this.nodeCapacity && (itemIndex = blockStart + i) < this.numItems; ++i) {
            if (!HPRtree.intersects(this.itemBounds, itemIndex * 4, searchEnv)) continue;
            visitor.visitItem(this.itemValues[itemIndex]);
        }
    }

    private int layerSize(int layerIndex) {
        int layerStart = this.layerStartIndex[layerIndex];
        int layerEnd = this.layerStartIndex[layerIndex + 1];
        return layerEnd - layerStart;
    }

    @Override
    public boolean remove(Envelope itemEnv, Object item) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        if (!this.isBuilt) {
            HPRtree hPRtree = this;
            synchronized (hPRtree) {
                if (!this.isBuilt) {
                    this.prepareIndex();
                    this.prepareItems();
                    this.isBuilt = true;
                }
            }
        }
    }

    private void prepareIndex() {
        if (this.itemsToLoad.size() <= this.nodeCapacity) {
            return;
        }
        this.sortItems();
        this.layerStartIndex = HPRtree.computeLayerIndices(this.numItems, this.nodeCapacity);
        int nodeCount = this.layerStartIndex[this.layerStartIndex.length - 1] / 4;
        this.nodeBounds = HPRtree.createBoundsArray(nodeCount);
        this.computeLeafNodes(this.layerStartIndex[1]);
        for (int i = 1; i < this.layerStartIndex.length - 1; ++i) {
            this.computeLayerNodes(i);
        }
    }

    private void prepareItems() {
        int boundsIndex = 0;
        int valueIndex = 0;
        this.itemBounds = new double[this.itemsToLoad.size() * 4];
        this.itemValues = new Object[this.itemsToLoad.size()];
        for (Item item : this.itemsToLoad) {
            Envelope envelope = item.getEnvelope();
            this.itemBounds[boundsIndex++] = envelope.getMinX();
            this.itemBounds[boundsIndex++] = envelope.getMinY();
            this.itemBounds[boundsIndex++] = envelope.getMaxX();
            this.itemBounds[boundsIndex++] = envelope.getMaxY();
            this.itemValues[valueIndex++] = item.getItem();
        }
        this.itemsToLoad = null;
    }

    private static double[] createBoundsArray(int size) {
        double[] a = new double[4 * size];
        for (int i = 0; i < size; ++i) {
            int index = 4 * i;
            a[index] = Double.MAX_VALUE;
            a[index + 1] = Double.MAX_VALUE;
            a[index + 2] = -1.7976931348623157E308;
            a[index + 3] = -1.7976931348623157E308;
        }
        return a;
    }

    private void computeLayerNodes(int layerIndex) {
        int layerStart = this.layerStartIndex[layerIndex];
        int childLayerStart = this.layerStartIndex[layerIndex - 1];
        int layerSize = this.layerSize(layerIndex);
        int childLayerEnd = layerStart;
        for (int i = 0; i < layerSize; i += 4) {
            int childStart = childLayerStart + this.nodeCapacity * i;
            this.computeNodeBounds(layerStart + i, childStart, childLayerEnd);
        }
    }

    private void computeNodeBounds(int nodeIndex, int blockStart, int nodeMaxIndex) {
        int index;
        for (int i = 0; i <= this.nodeCapacity && (index = blockStart + 4 * i) < nodeMaxIndex; ++i) {
            this.updateNodeBounds(nodeIndex, this.nodeBounds[index], this.nodeBounds[index + 1], this.nodeBounds[index + 2], this.nodeBounds[index + 3]);
        }
    }

    private void computeLeafNodes(int layerSize) {
        for (int i = 0; i < layerSize; i += 4) {
            this.computeLeafNodeBounds(i, this.nodeCapacity * i / 4);
        }
    }

    private void computeLeafNodeBounds(int nodeIndex, int blockStart) {
        int itemIndex;
        for (int i = 0; i <= this.nodeCapacity && (itemIndex = blockStart + i) < this.itemsToLoad.size(); ++i) {
            Envelope env = this.itemsToLoad.get(itemIndex).getEnvelope();
            this.updateNodeBounds(nodeIndex, env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
        }
    }

    private void updateNodeBounds(int nodeIndex, double minX, double minY, double maxX, double maxY) {
        if (minX < this.nodeBounds[nodeIndex]) {
            this.nodeBounds[nodeIndex] = minX;
        }
        if (minY < this.nodeBounds[nodeIndex + 1]) {
            this.nodeBounds[nodeIndex + 1] = minY;
        }
        if (maxX > this.nodeBounds[nodeIndex + 2]) {
            this.nodeBounds[nodeIndex + 2] = maxX;
        }
        if (maxY > this.nodeBounds[nodeIndex + 3]) {
            this.nodeBounds[nodeIndex + 3] = maxY;
        }
    }

    private static int[] computeLayerIndices(int itemSize, int nodeCapacity) {
        IntArrayList layerIndexList = new IntArrayList();
        int layerSize = itemSize;
        int index = 0;
        do {
            layerIndexList.add(index);
            layerSize = HPRtree.numNodesToCover(layerSize, nodeCapacity);
            index += 4 * layerSize;
        } while (layerSize > 1);
        return layerIndexList.toArray();
    }

    private static int numNodesToCover(int nChild, int nodeCapacity) {
        int mult = nChild / nodeCapacity;
        int total = mult * nodeCapacity;
        if (total == nChild) {
            return mult;
        }
        return mult + 1;
    }

    public Envelope[] getBounds() {
        int numNodes = this.nodeBounds.length / 4;
        Envelope[] bounds = new Envelope[numNodes];
        for (int i = numNodes - 1; i >= 0; --i) {
            int boundIndex = 4 * i;
            bounds[i] = new Envelope(this.nodeBounds[boundIndex], this.nodeBounds[boundIndex + 2], this.nodeBounds[boundIndex + 1], this.nodeBounds[boundIndex + 3]);
        }
        return bounds;
    }

    private void sortItems() {
        HilbertEncoder encoder = new HilbertEncoder(12, this.totalExtent);
        int[] hilbertValues = new int[this.itemsToLoad.size()];
        int pos = 0;
        for (Item item : this.itemsToLoad) {
            hilbertValues[pos++] = encoder.encode(item.getEnvelope());
        }
        this.quickSortItemsIntoNodes(hilbertValues, 0, this.itemsToLoad.size() - 1);
    }

    private void quickSortItemsIntoNodes(int[] values2, int lo, int hi) {
        if (lo / this.nodeCapacity < hi / this.nodeCapacity) {
            int pivot = this.hoarePartition(values2, lo, hi);
            this.quickSortItemsIntoNodes(values2, lo, pivot);
            this.quickSortItemsIntoNodes(values2, pivot + 1, hi);
        }
    }

    private int hoarePartition(int[] values2, int lo, int hi) {
        int pivot = values2[lo + hi >> 1];
        int i = lo - 1;
        int j = hi + 1;
        while (true) {
            if (values2[++i] < pivot) {
                continue;
            }
            while (values2[--j] > pivot) {
            }
            if (i >= j) {
                return j;
            }
            this.swapItems(values2, i, j);
        }
    }

    private void swapItems(int[] values2, int i, int j) {
        Item tmpItemp = this.itemsToLoad.get(i);
        this.itemsToLoad.set(i, this.itemsToLoad.get(j));
        this.itemsToLoad.set(j, tmpItemp);
        int tmpValue = values2[i];
        values2[i] = values2[j];
        values2[j] = tmpValue;
    }
}

